/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.init.InitMilestone;
import hudson.security.ACL;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.PipelineConfigUtils;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.Condition;
import io.alauda.kubernetes.api.model.DoneablePipelineConfig;
import io.alauda.kubernetes.api.model.Namespace;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigFluent;
import io.alauda.kubernetes.api.model.PipelineConfigList;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import io.alauda.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class PipelineConfigDepCheck
implements Callable<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(PipelineConfigDepCheck.class.getName());
    private AlaudaDevOpsClient client;

    private void handlePipelineConfig(String namespace) {
        PipelineConfigList list = (PipelineConfigList)((NonNamespaceOperation)this.client.pipelineConfigs().inNamespace(namespace)).list();
        if (list == null || list.getItems() == null) {
            return;
        }
        list.getItems().stream().forEach(pipelineConfig -> {
            if (!ResourcesCache.getInstance().isBinding((PipelineConfig)pipelineConfig)) {
                return;
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            PipelineConfigUtils.dependencyCheck(pipelineConfig, conditions);
            ((DoneablePipelineConfig)((PipelineConfigFluent.StatusNested)((PipelineConfigFluent.StatusNested)((PipelineConfigFluent.StatusNested)((DoneablePipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)this.client.pipelineConfigs().inNamespace(namespace)).withName(pipelineConfig.getMetadata().getName())).edit()).editStatus().withConditions(conditions)).withPhase(conditions.size() == 0 ? "Ready" : "Error")).withMessage(conditions.size() == 0 ? "" : "plugin dependencies error")).endStatus()).done();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        Jenkins j = Jenkins.getInstance();
        if (j == null || j.getInitLevel() != InitMilestone.COMPLETED) {
            return false;
        }
        SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            List folders = j.getItems(Folder.class);
            if (folders == null || folders.size() == 0) {
                LOGGER.warning("Found zero folder in Jenkins.");
                Boolean bl = true;
                return bl;
            }
            this.client = AlaudaUtils.getAuthenticatedAlaudaClient();
            if (this.client == null) {
                AlaudaUtils.initializeAlaudaDevOpsClient(AlaudaSyncGlobalConfiguration.get().getServer());
                LOGGER.warning("Can't get the Kubernetes client.");
                Boolean bl = false;
                return bl;
            }
            folders.stream().filter(folder -> folder.getItems().size() > 0).forEach(folder -> {
                String ns = folder.getName();
                Namespace namespace = (Namespace)((Resource)this.client.namespaces().withName(ns)).get();
                if (namespace != null) {
                    this.handlePipelineConfig(ns);
                }
            });
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)previousContext);
        }
        return true;
    }
}

