/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.security.ACL;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class OrphanJobCheck
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(OrphanJobCheck.class.getName());
    private List<Item> orphanList = new ArrayList<Item>();

    public OrphanJobCheck() {
        super("OrphanJobCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            LOGGER.severe("AlaudaDevOpsClient is null, skip scan orphan items.");
            return;
        }
        LOGGER.info("Start to scan orphan items.");
        this.orphanList.clear();
        SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            this.scanOrphanItems(client);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)previousContext);
        }
    }

    private void scanOrphanItems(AlaudaDevOpsClient client) {
        Jenkins jenkins = Jenkins.getInstance();
        List folders = jenkins.getItems(Folder.class);
        folders.forEach(folder -> folder.getItems().stream().filter(item -> {
            if (!(item instanceof WorkflowJob)) {
                return false;
            }
            PipelineConfigProjectProperty pro = (PipelineConfigProjectProperty)((WorkflowJob)item).getProperty(PipelineConfigProjectProperty.class);
            return pro != null && pro.isValid();
        }).forEach(item -> {
            PipelineConfigProjectProperty pro = (PipelineConfigProjectProperty)((WorkflowJob)item).getProperty(PipelineConfigProjectProperty.class);
            String ns = pro.getNamespace();
            String name = pro.getName();
            String uid = pro.getUid();
            ResourcesCache cache = ResourcesCache.getInstance();
            PipelineConfig pc = cache.getPipelineConfig(ns, name);
            if (pc == null) {
                PipelineConfig newer = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)client.pipelineConfigs().inNamespace(ns)).withName(name)).get();
                if (newer == null || !newer.getMetadata().getUid().equals(uid)) {
                    this.orphanList.add((Item)item);
                }
            } else if (!pc.getMetadata().getUid().equals(uid)) {
                this.orphanList.add((Item)item);
            }
        }));
        LOGGER.info(String.format("Start to remove orphan items[%s].", this.orphanList.size()));
        this.orphanList.forEach(item -> {
            try {
                item.delete();
                LOGGER.info(String.format("Remove orphan item [%s].", item.getFullName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(15L);
    }
}

