/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.model.Cause;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.Pipeline;
import org.apache.commons.lang.StringUtils;

public class JenkinsPipelineCause
extends Cause {
    private String uid;
    private String namespace;
    private String name;
    private String gitUri;
    private String commit;
    private String pipelineConfigUid;
    private int numStages = -1;
    private int numFlowNodes = -1;
    private long lastUpdateToAlaudaDevOps = -1L;
    private boolean synced = true;

    public JenkinsPipelineCause(String uid, String namespace, String name, String gitUri, String commit, String pipelineConfigUid) {
        this.uid = uid;
        this.namespace = namespace;
        this.name = name;
        this.gitUri = gitUri;
        this.commit = commit;
        this.pipelineConfigUid = pipelineConfigUid;
    }

    public JenkinsPipelineCause(String uid, String namespace, String name, String gitUri, String commit, String pipelineConfigUid, int numStages, int numFlowNodes, long lastUpdateToAlaudaDevOps) {
        this(uid, namespace, name, gitUri, commit, pipelineConfigUid);
        this.numStages = numStages;
        this.numFlowNodes = numFlowNodes;
        this.lastUpdateToAlaudaDevOps = lastUpdateToAlaudaDevOps;
    }

    public JenkinsPipelineCause(Pipeline pipeline, String pipelineConfigUid) {
        this.pipelineConfigUid = pipelineConfigUid;
        if (pipeline == null || pipeline.getMetadata() == null) {
            return;
        }
        ObjectMeta meta = pipeline.getMetadata();
        this.uid = meta.getUid();
        this.namespace = meta.getNamespace();
        this.name = meta.getName();
        if (pipeline.getSpec() != null) {
            if (pipeline.getSpec().getSource() != null && pipeline.getSpec().getSource().getGit() != null) {
                this.gitUri = pipeline.getSpec().getSource().getGit().getUri();
            }
            if (pipeline.getMetadata().getAnnotations() != null && pipeline.getMetadata().getAnnotations().containsKey("alauda.io/commit")) {
                this.commit = (String)pipeline.getMetadata().getAnnotations().get("alauda.io/commit");
            }
        }
    }

    public String getShortDescription() {
        StringBuilder sb = new StringBuilder("Alauda DevOps Pipeline ").append(this.namespace).append("/").append(this.name);
        if (StringUtils.isNotBlank((String)this.gitUri)) {
            sb.append(" from ").append(this.gitUri);
            if (StringUtils.isNotBlank((String)this.commit)) {
                sb.append(", commit ").append(this.commit);
            }
        }
        return sb.toString();
    }

    public String getUid() {
        return this.uid;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getGitUri() {
        return this.gitUri;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getPipelineConfigUid() {
        return this.pipelineConfigUid;
    }

    public int getNumStages() {
        return this.numStages;
    }

    public void setNumStages(int numStages) {
        this.numStages = numStages;
    }

    public int getNumFlowNodes() {
        return this.numFlowNodes;
    }

    public void setNumFlowNodes(int numFlowNodes) {
        this.numFlowNodes = numFlowNodes;
    }

    public long getLastUpdateToAlaudaDevOps() {
        return this.lastUpdateToAlaudaDevOps;
    }

    public void setLastUpdateToAlaudaDevOps(long lastUpdateToAlaudaDevOps) {
        this.lastUpdateToAlaudaDevOps = lastUpdateToAlaudaDevOps;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }
}

