/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class EmptyFolderCheck
extends AsyncPeriodicWork {
    private List<Folder> folders = null;

    public EmptyFolderCheck() {
        super("EmptyFolderCheck");
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            this.folders = Jenkins.getInstance().getItems(Folder.class);
            if (this.folders == null) {
                return;
            }
            this.folders.stream().filter(folder -> folder.getProperties().stream().anyMatch(pro -> pro instanceof AlaudaFolderProperty && ((AlaudaFolderProperty)((Object)((Object)pro))).isDirty())).filter(folder -> {
                Collection items = folder.getItems();
                if (items.size() == 0) {
                    return true;
                }
                return items.stream().noneMatch(item -> {
                    if (item instanceof WorkflowJob) {
                        return ((WorkflowJob)item).getProperty(PipelineConfigProjectProperty.class) == null;
                    }
                    return false;
                });
            }).forEach(folder -> {
                try {
                    folder.delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)previousContext);
        }
    }

    public long getRecurrencePeriod() {
        return TimeUnit.MINUTES.toMillis(10L);
    }
}

