/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.util.HttpResponses;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"alaudaSyncSetting"})
public class AlaudaSyncSettingMonitor
extends AdministrativeMonitor {
    public static final String ID = "AlaudaSyncSetting";
    private String syncServiceName;
    private boolean syncEnable;

    static AlaudaSyncSettingMonitor get(Jenkins j) {
        return (AlaudaSyncSettingMonitor)j.getAdministrativeMonitor(ID);
    }

    public AlaudaSyncSettingMonitor() {
        super(ID);
    }

    public String getDisplayName() {
        return ID;
    }

    public boolean isActivated() {
        AlaudaSyncGlobalConfiguration config = AlaudaSyncGlobalConfiguration.get();
        if (config == null) {
            return true;
        }
        this.syncEnable = config.isEnabled();
        this.syncServiceName = config.getJenkinsService();
        return this.syncServiceName == null || "".equals(this.syncServiceName.trim()) || !this.syncEnable;
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return HttpResponses.redirectViaContextPath((String)"/configure");
    }

    public String getSyncServiceName() {
        return this.syncServiceName;
    }

    public boolean isSyncEnable() {
        return this.syncEnable;
    }
}

