/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.alauda.jenkins.devops.sync.action.KubernetesClientAction;
import io.alauda.jenkins.devops.sync.credential.AlaudaToken;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.watcher.JenkinsBindingWatcher;
import io.alauda.jenkins.devops.sync.watcher.NamespaceWatcher;
import io.alauda.jenkins.devops.sync.watcher.PipelineConfigWatcher;
import io.alauda.jenkins.devops.sync.watcher.PipelineWatcher;
import io.alauda.jenkins.devops.sync.watcher.ResourcesCache;
import io.alauda.jenkins.devops.sync.watcher.SecretWatcher;
import io.alauda.kubernetes.client.KubernetesClientException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=100.0)
@Symbol(value={"alaudaSync"})
public class AlaudaSyncGlobalConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AlaudaSyncGlobalConfiguration.class.getName());
    private boolean enabled = true;
    private String server;
    private String credentialsId = "";
    private String jenkinsService;
    private String jobNamePattern;
    private String skipOrganizationPrefix;
    private String skipBranchSuffix;
    private String sharedNamespace;
    private int watcherAliveCheck = 5;
    private String[] namespaces;
    private transient PipelineWatcher pipelineWatcher;
    private transient PipelineConfigWatcher pipelineConfigWatcher;
    private transient SecretWatcher secretWatcher;
    private transient JenkinsBindingWatcher jenkinsBindingWatcher;
    private transient NamespaceWatcher namespaceWatcher;

    public AlaudaSyncGlobalConfiguration() {
        this.load();
    }

    public static AlaudaSyncGlobalConfiguration get() {
        return (AlaudaSyncGlobalConfiguration)((Object)GlobalConfiguration.all().get(AlaudaSyncGlobalConfiguration.class));
    }

    @Nonnull
    public String getDisplayName() {
        return "Alauda Jenkins Sync";
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValid() {
        return this.isEnabled() && !"".equals(this.getJenkinsService());
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @DataBoundSetter
    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getJenkinsService() {
        return this.jenkinsService;
    }

    @DataBoundSetter
    public void setJenkinsService(String jenkinsService) {
        this.jenkinsService = jenkinsService != null ? jenkinsService.trim() : null;
    }

    public String getJobNamePattern() {
        return this.jobNamePattern;
    }

    @DataBoundSetter
    public void setJobNamePattern(String jobNamePattern) {
        this.jobNamePattern = jobNamePattern;
    }

    public String getSkipOrganizationPrefix() {
        return this.skipOrganizationPrefix;
    }

    @DataBoundSetter
    public void setSkipOrganizationPrefix(String skipOrganizationPrefix) {
        this.skipOrganizationPrefix = skipOrganizationPrefix;
    }

    public String getSkipBranchSuffix() {
        return this.skipBranchSuffix;
    }

    @DataBoundSetter
    public void setSkipBranchSuffix(String skipBranchSuffix) {
        this.skipBranchSuffix = skipBranchSuffix;
    }

    public String getSharedNamespace() {
        return this.sharedNamespace;
    }

    @DataBoundSetter
    public void setSharedNamespace(String sharedNamespace) {
        this.sharedNamespace = sharedNamespace;
    }

    public int getWatcherAliveCheck() {
        return this.watcherAliveCheck;
    }

    @DataBoundSetter
    public void setWatcherAliveCheck(int watcherAliveCheck) {
        this.watcherAliveCheck = watcherAliveCheck;
    }

    @Nonnull
    public String[] getNamespaces() {
        if (this.namespaces == null) {
            return new String[0];
        }
        return Arrays.copyOf(this.namespaces, this.namespaces.length);
    }

    public static ListBoxModel doFillCredentialsIdItems(String credentialsId) {
        Jenkins jenkins = Jenkins.getInstance();
        return !jenkins.hasPermission(Jenkins.ADMINISTER) ? new StandardListBoxModel().includeCurrentValue(credentialsId) : new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)jenkins, AlaudaToken.class).includeCurrentValue(credentialsId);
    }

    public FormValidation doVerifyConnect(@QueryParameter String server, @QueryParameter String credentialId) {
        try {
            URL url = new KubernetesClientAction().connectTest(server, credentialId);
            return FormValidation.ok((String)String.format("Connect to %s success.", url.toString()));
        }
        catch (KubernetesClientException e) {
            return FormValidation.error((Throwable)e, (String)"Failed to connect kubernetes");
        }
    }

    public void reloadNamespaces() {
        for (String namespace : this.namespaces = AlaudaUtils.getNamespaceOrUseDefault(this.jenkinsService, AlaudaUtils.getAlaudaClient())) {
            ResourcesCache.getInstance().addNamespace(namespace);
        }
    }

    public void reWatchAllNamespace(String namespace) {
        this.stopWatchers();
        this.reloadNamespaces();
        ArrayList<String> namespaceList = new ArrayList<String>();
        namespaceList.add(namespace);
        for (String old : this.namespaces) {
            if (old.equals(namespace)) continue;
            namespaceList.add(old);
        }
        this.namespaces = namespaceList.toArray(new String[0]);
        this.startWatchers();
    }

    public void configChange() throws KubernetesClientException {
        ResourcesCache.getInstance().setJenkinsService(this.jenkinsService);
        if (!this.enabled || StringUtils.isBlank((String)this.jenkinsService)) {
            this.stopWatchersAndClient();
            LOGGER.warning("Plugin is disabled, all watchers will be stoped.");
            return;
        }
        ResourcesCache.getInstance().setJenkinsService(this.jenkinsService);
        try {
            this.stopWatchersAndClient();
            if (AlaudaUtils.getAlaudaClient() == null) {
                AlaudaUtils.initializeAlaudaDevOpsClient(this.server);
            }
            this.reloadNamespaces();
            SafeTimerTask task = new SafeTimerTask(){

                protected void doRun() throws Exception {
                    LOGGER.info("Waiting for Jenkins to be started");
                    while (true) {
                        Jenkins instance = Jenkins.getInstance();
                        InitMilestone initLevel = instance.getInitLevel();
                        LOGGER.fine("Jenkins init level: " + initLevel.toString());
                        if (initLevel == InitMilestone.COMPLETED) {
                            AlaudaSyncGlobalConfiguration.this.startWatchers();
                            return;
                        }
                        LOGGER.fine("Jenkins not ready...");
                        Thread.sleep(500L);
                    }
                }
            };
            Timer.get().schedule((Runnable)task, 1L, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException e) {
            if (e.getCause() != null) {
                LOGGER.log(Level.SEVERE, "Failed to configure Alauda Jenkins Sync Plugin: " + e.getCause());
            } else {
                LOGGER.log(Level.SEVERE, "Failed to configure Alauda Jenkins Sync Plugin: " + (Object)((Object)e));
            }
            throw e;
        }
    }

    public void startWatchers() {
        this.jenkinsBindingWatcher = new JenkinsBindingWatcher();
        this.jenkinsBindingWatcher.watch();
        this.pipelineWatcher = new PipelineWatcher();
        this.pipelineWatcher.watch();
        this.pipelineWatcher.init(this.namespaces);
        this.pipelineConfigWatcher = new PipelineConfigWatcher();
        this.pipelineConfigWatcher.watch();
        this.pipelineConfigWatcher.init(this.namespaces);
        this.secretWatcher = new SecretWatcher();
        this.secretWatcher.watch();
        this.secretWatcher.init(this.namespaces);
        this.namespaceWatcher = new NamespaceWatcher();
        this.namespaceWatcher.watch();
    }

    public void stopWatchers() {
        if (this.pipelineWatcher != null) {
            this.pipelineWatcher.stop();
            this.pipelineWatcher = null;
        }
        if (this.pipelineConfigWatcher != null) {
            this.pipelineConfigWatcher.stop();
            this.pipelineConfigWatcher = null;
        }
        if (this.secretWatcher != null) {
            this.secretWatcher.stop();
            this.secretWatcher = null;
        }
        if (this.jenkinsBindingWatcher != null) {
            this.jenkinsBindingWatcher.stop();
            this.jenkinsBindingWatcher = null;
        }
        if (this.namespaceWatcher != null) {
            this.namespaceWatcher.stop();
            this.namespaceWatcher = null;
        }
    }

    public PipelineWatcher getPipelineWatcher() {
        return this.pipelineWatcher;
    }

    public PipelineConfigWatcher getPipelineConfigWatcher() {
        return this.pipelineConfigWatcher;
    }

    public SecretWatcher getSecretWatcher() {
        return this.secretWatcher;
    }

    public JenkinsBindingWatcher getJenkinsBindingWatcher() {
        return this.jenkinsBindingWatcher;
    }

    public void setPipelineWatcher(PipelineWatcher pipelineWatcher) {
        this.pipelineWatcher = pipelineWatcher;
    }

    public void setPipelineConfigWatcher(PipelineConfigWatcher pipelineConfigWatcher) {
        this.pipelineConfigWatcher = pipelineConfigWatcher;
    }

    public void setSecretWatcher(SecretWatcher secretWatcher) {
        this.secretWatcher = secretWatcher;
    }

    public void setJenkinsBindingWatcher(JenkinsBindingWatcher jenkinsBindingWatcher) {
        this.jenkinsBindingWatcher = jenkinsBindingWatcher;
    }

    public NamespaceWatcher getNamespaceWatcher() {
        return this.namespaceWatcher;
    }

    public void stopWatchersAndClient() {
        this.stopWatchers();
        AlaudaUtils.shutdownAlaudaClient();
    }
}

