/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.watcher;

import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.kubernetes.api.model.JenkinsBinding;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.Secret;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourcesCache {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String jenkinsService;
    private Set<String> namespaces = new CopyOnWriteArraySet<String>();
    private Set<String> pipelineConfigs = new CopyOnWriteArraySet<String>();
    private Map<String, String> bindingMap = new ConcurrentHashMap<String, String>();
    private static final ResourcesCache RESOURCES_CACHE = new ResourcesCache();

    private ResourcesCache() {
    }

    public static ResourcesCache getInstance() {
        return RESOURCES_CACHE;
    }

    public String getJenkinsService() {
        return this.jenkinsService;
    }

    public void setJenkinsService(String jenkinsService) {
        this.jenkinsService = jenkinsService;
    }

    public void addNamespace(String namespace) {
        this.namespaces.add(namespace);
        this.printNamespaces();
    }

    public void addNamespace(JenkinsBinding jenkinsBinding) {
        String jenkinsName = jenkinsBinding.getSpec().getJenkins().getName();
        if (jenkinsName.equals(this.jenkinsService)) {
            String namespace = jenkinsBinding.getMetadata().getNamespace();
            this.addNamespace(namespace);
            this.addJenkinsBinding(jenkinsBinding);
        }
    }

    public void removeNamespace(String namespace) {
        this.namespaces.remove(namespace);
        this.printNamespaces();
    }

    public void removeNamespace(JenkinsBinding jenkinsBinding) {
        String jenkinsName = jenkinsBinding.getSpec().getJenkins().getName();
        if (jenkinsName.equals(this.jenkinsService)) {
            String namespace = jenkinsBinding.getMetadata().getNamespace();
            this.removeNamespace(namespace);
            this.removeJenkinsBinding(jenkinsBinding);
        }
    }

    public void addPipelineConfig(PipelineConfig pipelineConfig) {
        String pipelineConfigName = pipelineConfig.getMetadata().getName();
        this.pipelineConfigs.add(pipelineConfigName);
    }

    public void addJenkinsBinding(JenkinsBinding jenkinsBinding) {
        this.bindingMap.put(jenkinsBinding.getMetadata().getName(), jenkinsBinding.getSpec().getJenkins().getName());
    }

    public void removeJenkinsBinding(JenkinsBinding jenkinsBinding) {
        this.bindingMap.remove(jenkinsBinding.getMetadata().getName());
    }

    public boolean isBinding(PipelineConfig pipelineConfig) {
        String bindingName = pipelineConfig.getSpec().getJenkinsBinding().getName();
        String namespace = pipelineConfig.getMetadata().getNamespace();
        return this.isBinding(bindingName, namespace);
    }

    public boolean isBinding(Pipeline pipeline) {
        String bindingName = pipeline.getSpec().getJenkinsBinding().getName();
        String namespace = pipeline.getMetadata().getNamespace();
        return this.isBinding(bindingName, namespace);
    }

    private boolean isBinding(String bindingName, String namespace) {
        String bindingService = this.bindingMap.get(bindingName);
        this.printNamespaces();
        return bindingService != null && bindingService.equals(this.jenkinsService) && this.namespaces.contains(namespace);
    }

    public boolean isBinding(Secret secret) {
        String namespace = secret.getMetadata().getNamespace();
        this.printNamespaces();
        return this.namespaces.contains(namespace) || namespace.equals(AlaudaSyncGlobalConfiguration.get().getSharedNamespace());
    }

    public void printNamespaces() {
        this.logger.log(Level.FINE, "Syncing namespaces", this.namespaces.toArray());
    }
}

