/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

public class PipelineName {
    private final String jobName;
    private final String pipelineName;

    public static PipelineName parsePipelineUrl(String url) {
        while (url.startsWith("/")) {
            url = url.substring(1);
        }
        String[] split = url.split("/");
        if (split.length < 3) {
            throw new IllegalArgumentException("Invalid build URL `" + url + " ` expecting at least 2 '/' characters!");
        }
        return new PipelineName(split[1], split[2]);
    }

    public PipelineName(String jobName, String pipelineName) {
        this.jobName = jobName;
        this.pipelineName = pipelineName;
    }

    public String toString() {
        return "PipelineName{jobName='" + this.jobName + '\'' + ", pipelineName='" + this.pipelineName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineName pipeName = (PipelineName)o;
        if (!this.jobName.equals(pipeName.jobName)) {
            return false;
        }
        return this.pipelineName.equals(pipeName.pipelineName);
    }

    public int hashCode() {
        int result = this.jobName.hashCode();
        result = 31 * result + this.pipelineName.hashCode();
        return result;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getJobName() {
        return this.jobName;
    }
}

