/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.model.Action;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.ParameterUtils;
import io.alauda.kubernetes.api.model.DoneablePipeline;
import io.alauda.kubernetes.api.model.LocalObjectReference;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineCause;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigSpec;
import io.alauda.kubernetes.api.model.PipelineFluent;
import io.alauda.kubernetes.api.model.PipelineParameter;
import io.alauda.kubernetes.api.model.PipelineSpec;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class PipelineGenerator {
    private static final Logger LOGGER = Logger.getLogger(PipelineGenerator.class.getName());
    private static String TRIGGER_BY = "Triggered by Jenkins job at ";

    public static Pipeline buildPipeline(PipelineConfig config, List<Action> actions) {
        return PipelineGenerator.buildPipeline(config, null, actions);
    }

    public static Pipeline buildPipeline(PipelineConfig config, String triggerURL, List<Action> actions) {
        PipelineSpec pipelineSpec = PipelineGenerator.buildPipelineSpec(config, triggerURL);
        String cause = null;
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            if (cause == null) {
                if (causeAction.findCause(SCMTrigger.SCMTriggerCause.class) != null) {
                    cause = "codeChange";
                    continue;
                }
                if (causeAction.findCause(TimerTrigger.TimerTriggerCause.class) == null) continue;
                cause = "cron";
                continue;
            }
            LOGGER.fine("CauseAction is : " + causeAction.getDisplayName());
        }
        if (cause == null) {
            cause = "manual";
        }
        PipelineCause pipelineCause = new PipelineCause(TRIGGER_BY + triggerURL, cause);
        pipelineSpec.setCause(pipelineCause);
        for (Action action : actions) {
            ParametersAction paramAction;
            if (!(action instanceof ParametersAction) || (paramAction = (ParametersAction)action).getParameters() == null) continue;
            ArrayList<PipelineParameter> parameters = new ArrayList<PipelineParameter>();
            for (ParameterValue param : paramAction.getParameters()) {
                PipelineParameter pipeParam = ParameterUtils.to(param);
                if (pipeParam == null) continue;
                parameters.add(pipeParam);
            }
            pipelineSpec.setParameters(parameters);
        }
        String string = config.getMetadata().getNamespace();
        return ((DoneablePipeline)((DoneablePipeline)((PipelineFluent.MetadataNested)((PipelineFluent.MetadataNested)((DoneablePipeline)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(string)).createNew()).withNewMetadata().withName(config.getMetadata().getName())).withNamespace(string)).endMetadata()).withSpec(pipelineSpec)).done();
    }

    public static PipelineSpec buildPipelineSpec(PipelineConfig config) {
        return PipelineGenerator.buildPipelineSpec(config, null);
    }

    private static PipelineSpec buildPipelineSpec(PipelineConfig config, String triggerURL) {
        PipelineSpec pipeSpec = new PipelineSpec();
        PipelineConfigSpec spec = config.getSpec();
        pipeSpec.setPipelineConfig(new LocalObjectReference(config.getMetadata().getName()));
        pipeSpec.setJenkinsBinding(spec.getJenkinsBinding());
        pipeSpec.setRunPolicy(spec.getRunPolicy());
        pipeSpec.setTriggers(spec.getTriggers());
        pipeSpec.setStrategy(spec.getStrategy());
        pipeSpec.setHooks(spec.getHooks());
        pipeSpec.setSource(spec.getSource());
        return pipeSpec;
    }
}

