/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.BooleanParameterValue;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.git.RevisionParameterAction;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.TimerTrigger;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.PipelineComparator;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CollectionUtils;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.PipelineConfigToJobMap;
import io.alauda.jenkins.devops.sync.util.PipelineToActionMapper;
import io.alauda.jenkins.devops.sync.watcher.PipelineWatcher;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineBuilder;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineFluent;
import io.alauda.kubernetes.api.model.PipelineList;
import io.alauda.kubernetes.api.model.PipelineParameter;
import io.alauda.kubernetes.api.model.PipelineSourceGit;
import io.alauda.kubernetes.api.model.PipelineTrigger;
import io.alauda.kubernetes.api.model.PipelineTriggerCodeChange;
import io.alauda.kubernetes.api.model.PipelineTriggerCron;
import io.alauda.kubernetes.client.dsl.FilterWatchListDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.job.properties.PipelineTriggersJobProperty;

public abstract class JenkinsUtils {
    private static final Logger LOGGER = Logger.getLogger(JenkinsUtils.class.getName());
    public static final String PARAM_FROM_ENV_DESCRIPTION = "From Alauda DevOps PipelineConfig Parameter";

    private JenkinsUtils() {
    }

    public static Job getJob(String job) {
        TopLevelItem item = Jenkins.getInstance().getItem(job);
        if (item instanceof Job) {
            return (Job)item;
        }
        return null;
    }

    @NotNull
    public static String getRootUrl() {
        String root = Jenkins.getInstance().getRootUrl();
        return StringUtils.isBlank((String)root) ? "http://localhost:8080/" : root;
    }

    public static boolean verifyEnvVars(Map<String, ParameterDefinition> paramMap, WorkflowJob workflowJob) {
        if (paramMap != null) {
            String fullName = workflowJob.getFullName();
            WorkflowJob job = (WorkflowJob)Jenkins.getInstance().getItemByFullName(fullName, WorkflowJob.class);
            if (job == null) {
                LOGGER.warning(() -> "A run of workflow job " + workflowJob.getName() + " unexpectantly not saved to disk.");
                return false;
            }
            ParametersDefinitionProperty props = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            List names = props.getParameterDefinitionNames();
            for (String name : names) {
                if (paramMap.containsKey(name)) continue;
                LOGGER.warning(() -> "A run of workflow job " + job.getName() + " was expecting parameter " + name + ", but it is not in the parameter list");
                return false;
            }
        }
        return true;
    }

    public static Map<String, ParameterDefinition> addJobParamForPipelineParameters(WorkflowJob job, List<PipelineParameter> params, boolean replaceExisting) throws IOException {
        ParametersDefinitionProperty jenkinsParams = (ParametersDefinitionProperty)job.removeProperty(ParametersDefinitionProperty.class);
        HashMap<String, Object> paramMap = null;
        if (params != null && params.size() > 0) {
            ArrayList<String> envKeys = new ArrayList<String>();
            for (PipelineParameter pipelineParameter : params) {
                envKeys.add(pipelineParameter.getName());
            }
            paramMap = new HashMap<String, Object>();
            if (jenkinsParams != null) {
                List existingParamList = jenkinsParams.getParameterDefinitions();
                Iterator iterator = existingParamList.iterator();
                while (iterator.hasNext()) {
                    ParameterDefinition param = (ParameterDefinition)iterator.next();
                    if (param.getDescription() == null || !param.getDescription().equals(PARAM_FROM_ENV_DESCRIPTION)) {
                        paramMap.put(param.getName(), param);
                        continue;
                    }
                    if (!envKeys.contains(param.getName())) continue;
                    paramMap.put(param.getName(), param);
                }
            }
            for (PipelineParameter pipelineParameter : params) {
                StringParameterDefinition jenkinsParam = null;
                switch (pipelineParameter.getType()) {
                    case "string": {
                        jenkinsParam = new StringParameterDefinition(pipelineParameter.getName(), pipelineParameter.getValue(), pipelineParameter.getDescription());
                        break;
                    }
                    case "boolean": {
                        jenkinsParam = new BooleanParameterDefinition(pipelineParameter.getName(), Boolean.valueOf(pipelineParameter.getValue()).booleanValue(), pipelineParameter.getDescription());
                        break;
                    }
                    default: {
                        LOGGER.warning(() -> "Parameter type `" + param.getType() + "` is not supported.. skipping...");
                    }
                }
                if (jenkinsParam == null || !replaceExisting && paramMap.containsKey(jenkinsParam.getName())) continue;
                paramMap.put(jenkinsParam.getName(), jenkinsParam);
            }
            ArrayList newParamList = new ArrayList(paramMap.values());
            job.addProperty((JobProperty)new ParametersDefinitionProperty(newParamList));
        }
        job.save();
        return paramMap;
    }

    @NotNull
    public static List<ANTLRException> setJobTriggers(@Nonnull WorkflowJob job, List<PipelineTrigger> triggers) throws IOException {
        ArrayList<ANTLRException> exceptions = new ArrayList<ANTLRException>();
        if (CollectionUtils.isEmpty(triggers)) {
            return exceptions;
        }
        job.removeProperty(PipelineTriggersJobProperty.class);
        LOGGER.info(() -> "PipelineTrigger's count is " + triggers.size());
        for (PipelineTrigger pipelineTrigger : triggers) {
            SCMTrigger trigger = null;
            String type = pipelineTrigger.getType();
            if (type == null) continue;
            switch (type) {
                case "codeChange": {
                    PipelineTriggerCodeChange codeTrigger = pipelineTrigger.getCodeChange();
                    if (codeTrigger == null || !codeTrigger.getEnabled().booleanValue()) {
                        LOGGER.warning(() -> "Trigger type `codeChange` has empty description or is disabled...");
                        break;
                    }
                    try {
                        trigger = new SCMTrigger(codeTrigger.getPeriodicCheck());
                        LOGGER.info(() -> "Add CodeChangeTrigger.");
                    }
                    catch (ANTLRException exc) {
                        LOGGER.log(Level.SEVERE, String.format("Error processing trigger type %s", "codeChange"), exc);
                        exceptions.add(exc);
                    }
                    break;
                }
                case "cron": {
                    PipelineTriggerCron cronTrigger = pipelineTrigger.getCron();
                    if (cronTrigger == null || !cronTrigger.getEnabled().booleanValue()) {
                        LOGGER.warning(() -> "Trigger type `cron` has empty description or is disabled...");
                        break;
                    }
                    try {
                        trigger = new TimerTrigger(cronTrigger.getRule());
                        LOGGER.info(() -> "Add CronTrigger.");
                    }
                    catch (ANTLRException exc) {
                        LOGGER.log(Level.SEVERE, String.format("Error processing trigger type %s", "cron"), exc);
                        exceptions.add(exc);
                    }
                    break;
                }
                default: {
                    LOGGER.warning(() -> "Trigger type `" + pipelineTrigger.getType() + "` is not supported... skipping...");
                }
            }
            if (trigger == null) continue;
            job.addTrigger(trigger);
        }
        LOGGER.info(() -> "Job trigger save done.");
        return exceptions;
    }

    @CheckForNull
    public static List<Action> putJobRunParamsFromEnvAndUIParams(List<PipelineParameter> pipelineParameters, List<Action> buildActions) {
        if (buildActions == null || pipelineParameters == null) {
            return buildActions;
        }
        List<ParameterValue> envVarList = JenkinsUtils.getParameterValues(pipelineParameters);
        if (envVarList.size() == 0) {
            return buildActions;
        }
        buildActions.add((Action)new ParametersAction(envVarList));
        return buildActions;
    }

    @Nonnull
    public static List<ParameterValue> getParameterValues(List<PipelineParameter> pipelineParameters) {
        ArrayList<ParameterValue> envVarList = new ArrayList<ParameterValue>();
        if (pipelineParameters == null) {
            return envVarList;
        }
        for (PipelineParameter pipeParam : pipelineParameters) {
            StringParameterValue paramValue = null;
            String type = pipeParam.getType();
            if (type == null) continue;
            switch (type) {
                case "string": {
                    paramValue = new StringParameterValue(pipeParam.getName(), pipeParam.getValue(), pipeParam.getDescription());
                    break;
                }
                case "boolean": {
                    paramValue = new BooleanParameterValue(pipeParam.getName(), Boolean.valueOf(pipeParam.getValue()).booleanValue(), pipeParam.getDescription());
                    break;
                }
                default: {
                    LOGGER.warning(() -> "Parameter type `" + pipeParam.getType() + "` is not supported.. skipping...");
                }
            }
            if (paramValue == null) continue;
            envVarList.add((ParameterValue)paramValue);
        }
        return envVarList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean triggerJob(@Nonnull WorkflowJob job, @Nonnull Pipeline pipeline) throws IOException {
        ObjectMeta pipMeta = pipeline.getMetadata();
        String namespace = pipMeta.getNamespace();
        String pipelineName = pipMeta.getName();
        LOGGER.info(() -> "will trigger pipeline: " + pipelineName);
        if (JenkinsUtils.isAlreadyTriggered(job, pipeline)) {
            LOGGER.info(() -> "pipeline already triggered: " + pipelineName);
            return false;
        }
        PipelineConfigProjectProperty pcProp = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
        if (pcProp == null) {
            LOGGER.warning(() -> "aborting trigger of pipeline " + pipeline + "because of missing pc project property");
            return false;
        }
        String pipelineConfigName = pipeline.getSpec().getPipelineConfig().getName();
        PipelineConfig pipelineConfig = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(namespace)).withName(pipelineConfigName)).get();
        if (pipelineConfig == null) {
            LOGGER.info(() -> "pipeline config not found....: " + pipelineName + " - config name " + pipelineConfigName);
            return false;
        }
        String string = pipelineConfig.getMetadata().getUid().intern();
        synchronized (string) {
            LOGGER.info(() -> "pipeline config source credentials: " + pipelineConfig.getMetadata().getName());
            CredentialsUtils.updateSourceCredentials(pipelineConfig);
            ArrayList<JenkinsPipelineCause> newCauses = new ArrayList<JenkinsPipelineCause>();
            newCauses.add(new JenkinsPipelineCause(pipeline, pcProp.getUid()));
            CauseAction originalCauseAction = PipelineToActionMapper.removeCauseAction(pipelineName);
            if (originalCauseAction != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding existing causes...");
                    for (Cause cause : originalCauseAction.getCauses()) {
                        LOGGER.log(Level.FINE, "trigger error", cause);
                    }
                }
                newCauses.addAll(originalCauseAction.getCauses());
                if (LOGGER.isLoggable(Level.FINE)) {
                    for (Cause cause : newCauses) {
                        LOGGER.log(Level.FINE, "trigger error", cause);
                    }
                }
            }
            ArrayList<Action> pipelineActions = new ArrayList<Action>();
            CauseAction causeAction = new CauseAction(newCauses);
            pipelineActions.add((Action)causeAction);
            PipelineSourceGit sourceGit = pipeline.getSpec().getSource().getGit();
            String commit = null;
            if (pipMeta.getAnnotations() != null && pipMeta.getAnnotations().containsKey("alauda.io/commit")) {
                commit = (String)pipMeta.getAnnotations().get("alauda.io/commit");
            }
            if (sourceGit != null && commit != null) {
                try {
                    URIish repoURL = new URIish(sourceGit.getUri());
                    pipelineActions.add((Action)new RevisionParameterAction(commit, repoURL));
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse git repo URL" + sourceGit.getUri(), e);
                }
            }
            LOGGER.info("pipeline got cause....: " + pipelineName + " pipeline actions " + pipelineActions);
            PipelineToActionMapper.removeParameterAction(pipelineName);
            JenkinsUtils.putJobRunParamsFromEnvAndUIParams(pipeline.getSpec().getParameters(), pipelineActions);
            PipelineConfigToJobMap.putJobWithPipelineConfig(job, pipelineConfig);
            LOGGER.info(() -> "pipeline config update with job: " + pipelineName + " pipeline config " + pipelineConfig.getMetadata().getName());
            Action[] actionArray = pipelineActions.size() == 0 ? new Action[]{} : pipelineActions.toArray(new Action[pipelineActions.size()]);
            QueueTaskFuture queueTaskFuture = job.scheduleBuild2(0, actionArray);
            if (queueTaskFuture != null) {
                AlaudaUtils.updatePipelinePhase(pipeline, "Queued");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "updatePipelinePhase Interrupted", e);
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            AlaudaUtils.updatePipelinePhase(pipeline, "Failed");
            LOGGER.info(() -> "Will not schedule build for this pipeline: " + pipelineName);
            return false;
        }
    }

    private static boolean isAlreadyTriggered(WorkflowJob job, Pipeline pipeline) {
        return JenkinsUtils.getRun(job, pipeline) != null;
    }

    public static synchronized void cancelPipeline(WorkflowJob job, Pipeline pipeline) {
        JenkinsUtils.cancelPipeline(job, pipeline, false);
    }

    public static synchronized void cancelPipeline(WorkflowJob job, Pipeline pipeline, boolean deleted) {
        if (!JenkinsUtils.cancelQueuedPipeline(job, pipeline)) {
            JenkinsUtils.cancelRunningPipeline(job, pipeline);
        }
        if (deleted) {
            return;
        }
        AlaudaUtils.updatePipelinePhase(pipeline, "Cancelled");
    }

    private static WorkflowRun getRun(WorkflowJob job, Pipeline pipeline) {
        if (pipeline != null && pipeline.getMetadata() != null) {
            return JenkinsUtils.getRun(job, pipeline.getMetadata().getUid());
        }
        return null;
    }

    private static WorkflowRun getRun(WorkflowJob job, String pipelineUid) {
        for (WorkflowRun run : job.getBuilds()) {
            JenkinsPipelineCause cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class);
            if (cause == null || !cause.getUid().equals(pipelineUid)) continue;
            return run;
        }
        return null;
    }

    public static void deleteRun(WorkflowJob workflowJob, Pipeline pipeline) {
        WorkflowRun run = JenkinsUtils.getRun(workflowJob, pipeline);
        if (run != null) {
            JenkinsUtils.deleteRun(run);
        }
    }

    public static synchronized void deleteRun(WorkflowRun run) {
        try {
            LOGGER.info("Deleting run: " + run.toString());
            run.delete();
        }
        catch (IOException e) {
            LOGGER.warning(() -> "Unable to delete run " + run.toString() + ":" + e.getMessage());
        }
    }

    private static boolean cancelRunningPipeline(WorkflowJob job, Pipeline pipeline) {
        String pipelineUid = pipeline.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, pipelineUid);
        if (run != null && run.isBuilding()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    private static boolean cancelNotYetStartedPipeline(WorkflowJob job, Pipeline pipeline) {
        String pipelineUid = pipeline.getMetadata().getUid();
        WorkflowRun run = JenkinsUtils.getRun(job, pipelineUid);
        if (run != null && run.hasntStartedYet()) {
            JenkinsUtils.terminateRun(run);
            return true;
        }
        return false;
    }

    private static void cancelNotYetStartedPipeliness(WorkflowJob job, String pcUid) {
        JenkinsUtils.cancelQueuedBuilds(job, pcUid);
        for (WorkflowRun run : job.getBuilds()) {
            JenkinsPipelineCause cause;
            if (run == null || !run.hasntStartedYet() || (cause = (JenkinsPipelineCause)run.getCause(JenkinsPipelineCause.class)) == null || !cause.getPipelineConfigUid().equals(pcUid)) continue;
            JenkinsUtils.terminateRun(run);
        }
    }

    private static void terminateRun(final WorkflowRun run) {
        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

            public Void call() throws RuntimeException {
                run.doTerm();
                Timer.get().schedule((Runnable)new SafeTimerTask(){

                    public void doRun() {
                        ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Void, RuntimeException>(){

                            public Void call() throws RuntimeException {
                                run.doKill();
                                return null;
                            }
                        });
                    }
                }, 5L, TimeUnit.SECONDS);
                return null;
            }
        });
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    public static boolean cancelQueuedPipeline(WorkflowJob job, Pipeline pipeline) {
        LOGGER.info("cancelling queued pipeline: " + pipeline.getMetadata().getName());
        String pipelineUid = pipeline.getMetadata().getUid();
        final Queue pipelineQueue = Jenkins.getInstance().getQueue();
        for (final Queue.Item item : pipelineQueue.getItems()) {
            for (Cause cause : item.getCauses()) {
                if (!(cause instanceof JenkinsPipelineCause) || !((JenkinsPipelineCause)cause).getUid().equals(pipelineUid)) continue;
                return (Boolean)ACL.impersonate((Authentication)ACL.SYSTEM, (Callable)new NotReallyRoleSensitiveCallable<Boolean, RuntimeException>(){

                    public Boolean call() throws RuntimeException {
                        pipelineQueue.cancel(item);
                        return true;
                    }
                });
            }
        }
        return JenkinsUtils.cancelNotYetStartedPipeline(job, pipeline);
    }

    public static void cancelQueuedBuilds(WorkflowJob job, String pcUid) {
        LOGGER.info(() -> "cancelling queued pipeline by uuid: " + pcUid);
        Queue pipelineQueue = Jenkins.getInstance().getQueue();
        for (Queue.Item item : pipelineQueue.getItems()) {
            for (Cause cause : item.getCauses()) {
                JenkinsPipelineCause pipelineCause;
                if (!(cause instanceof JenkinsPipelineCause) || !(pipelineCause = (JenkinsPipelineCause)cause).getPipelineConfigUid().equals(pcUid)) continue;
                Pipeline pipeline = ((PipelineBuilder)((PipelineFluent.MetadataNested)((PipelineFluent.MetadataNested)new PipelineBuilder().withNewMetadata().withNamespace(pipelineCause.getNamespace())).withName(pipelineCause.getName())).and()).build();
                JenkinsUtils.cancelQueuedPipeline(job, pipeline);
            }
        }
    }

    public static WorkflowJob getJobFromPipeline(@Nonnull Pipeline pipeline) {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            return null;
        }
        String configName = pipeline.getSpec().getPipelineConfig().getName();
        PipelineConfig pipelineConfig = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(pipeline.getMetadata().getNamespace())).withName(configName)).get();
        if (pipelineConfig == null) {
            return null;
        }
        return PipelineConfigToJobMap.getJobFromPipelineConfig(pipelineConfig);
    }

    public static void maybeScheduleNext(WorkflowJob job) {
        PipelineConfigProjectProperty pcp = (PipelineConfigProjectProperty)job.getProperty(PipelineConfigProjectProperty.class);
        if (pcp == null) {
            return;
        }
        PipelineList list = JenkinsUtils.filterNew((PipelineList)((FilterWatchListDeletable)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelines().inNamespace(pcp.getNamespace())).withLabel("pipelineConfig", pcp.getName())).list());
        LOGGER.info("Got new pipeline list: " + list.getItems());
        JenkinsUtils.handlePipelineList(job, list.getItems());
    }

    public static PipelineList filterNew(PipelineList list) {
        if (list == null || list.getItems() == null || list.getItems().size() == 0) {
            return list;
        }
        list.getItems().removeIf(p -> !AlaudaUtils.isNew(p.getStatus()));
        return list;
    }

    public static void handlePipelineList(WorkflowJob job, List<Pipeline> pipelines) {
        if (pipelines.isEmpty()) {
            return;
        }
        Collections.sort(pipelines, new PipelineComparator());
        boolean isSerial = !job.isConcurrentBuild();
        boolean jobIsBuilding = job.isBuilding();
        for (int i = 0; i < pipelines.size(); ++i) {
            Pipeline p = pipelines.get(i);
            if (!AlaudaUtils.isPipelineStrategyPipeline(p)) continue;
            if (jobIsBuilding && !AlaudaUtils.isCancelled(p.getStatus())) {
                return;
            }
            if (i < pipelines.size() - 1) {
                JenkinsUtils.cancelQueuedPipeline(job, p);
                AlaudaUtils.updatePipelinePhase(p, "Cancelled");
                continue;
            }
            boolean buildAdded = false;
            try {
                buildAdded = PipelineWatcher.addEventToJenkinsJobRun(p);
            }
            catch (IOException e) {
                ObjectMeta meta = p.getMetadata();
                LOGGER.log(Level.WARNING, "Failed to add new build " + meta.getNamespace() + "/" + meta.getName(), e);
            }
            if (!isSerial || !buildAdded) continue;
            return;
        }
    }

    @Nonnull
    public static String getFullJobName(@Nonnull WorkflowJob job) {
        return job.getRelativeNameFrom((ItemGroup)Jenkins.getInstance());
    }

    @Nonnull
    public static String getBuildConfigName(@Nonnull WorkflowJob job) {
        String orgName;
        String name = JenkinsUtils.getFullJobName(job);
        AlaudaSyncGlobalConfiguration config = AlaudaSyncGlobalConfiguration.get();
        String[] paths = name.split("/");
        if (paths.length > 1 && StringUtils.isNotBlank((String)(orgName = paths[0])) && config != null) {
            String skipOrganizationPrefix = config.getSkipOrganizationPrefix();
            if (StringUtils.isEmpty((String)skipOrganizationPrefix)) {
                config.setSkipOrganizationPrefix(orgName);
                skipOrganizationPrefix = config.getSkipOrganizationPrefix();
            }
            int prefixLength = orgName.length() + 1;
            if (orgName.equals(skipOrganizationPrefix) && name.length() > prefixLength) {
                name = name.substring(prefixLength);
            }
        }
        String masterSuffix = "/master";
        if (config != null) {
            String skipBranchSuffix = config.getSkipBranchSuffix();
            if (StringUtils.isEmpty((String)skipBranchSuffix)) {
                config.setSkipBranchSuffix("master");
                skipBranchSuffix = config.getSkipBranchSuffix();
            }
            masterSuffix = "/" + skipBranchSuffix;
        }
        if (name.endsWith(masterSuffix) && name.length() > masterSuffix.length()) {
            name = name.substring(0, name.length() - masterSuffix.length());
        }
        return name;
    }
}

