/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hudson.BulkChange;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.util.XStream2;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.AlaudaDevOpsConfigBuilder;
import io.alauda.devops.client.DefaultAlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineResource;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.kubernetes.api.model.HasMetadata;
import io.alauda.kubernetes.api.model.JenkinsBinding;
import io.alauda.kubernetes.api.model.JenkinsBindingList;
import io.alauda.kubernetes.api.model.JenkinsList;
import io.alauda.kubernetes.api.model.ObjectMeta;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.api.model.PipelineConfigSpec;
import io.alauda.kubernetes.api.model.PipelineSource;
import io.alauda.kubernetes.api.model.PipelineSourceGit;
import io.alauda.kubernetes.api.model.PipelineStatus;
import io.alauda.kubernetes.api.model.PipelineStatusBuilder;
import io.alauda.kubernetes.api.model.PipelineStrategy;
import io.alauda.kubernetes.api.model.PipelineStrategyJenkins;
import io.alauda.kubernetes.api.model.ReplicationController;
import io.alauda.kubernetes.api.model.ReplicationControllerStatus;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.Version;
import io.alauda.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AlaudaUtils {
    private static final Logger logger = Logger.getLogger(AlaudaUtils.class.getName());
    private static final String PLUGIN_NAME = "alauda-sync";
    private static AlaudaDevOpsClient alaudaClient;
    private static String jenkinsPodNamespace;
    private static final DateTimeFormatter dateFormatter;

    private AlaudaUtils() {
    }

    public static synchronized void initializeAlaudaDevOpsClient(String serverUrl) {
        AlaudaDevOpsConfig config;
        AlaudaDevOpsConfigBuilder configBuilder = new AlaudaDevOpsConfigBuilder();
        if (serverUrl != null && !serverUrl.isEmpty()) {
            configBuilder.withMasterUrl(serverUrl);
        }
        if ((config = configBuilder.build()) != null) {
            if (Jenkins.getInstance().getPluginManager() != null && Jenkins.getInstance().getPluginManager().getPlugin(PLUGIN_NAME) != null) {
                config.setUserAgent("alauda-sync-plugin-" + Jenkins.getInstance().getPluginManager().getPlugin(PLUGIN_NAME).getVersion() + "/alauda-devops-" + Version.clientVersion());
            }
            alaudaClient = new DefaultAlaudaDevOpsClient((Config)config);
            logger.info("Alauda client is created well.");
        } else {
            logger.warning("Config builder could not build a configuration for Alauda Connection");
        }
    }

    public static synchronized AlaudaDevOpsClient getAlaudaClient() {
        return alaudaClient;
    }

    public static synchronized AlaudaDevOpsClient getAuthenticatedAlaudaClient() {
        String token;
        if (alaudaClient != null && (token = CredentialsUtils.getCurrentToken()) != null && token.length() > 0) {
            alaudaClient.getConfiguration().setOauthToken(token);
        }
        return alaudaClient;
    }

    public static synchronized void shutdownAlaudaClient() {
        if (alaudaClient != null) {
            alaudaClient.close();
            alaudaClient = null;
        }
    }

    public static boolean isPipelineStrategyPipeline(Pipeline pipeline) {
        if (pipeline.getSpec() == null) {
            logger.warning("bad input, null spec: " + pipeline);
            return false;
        }
        PipelineStrategy strategy = pipeline.getSpec().getStrategy();
        if (strategy == null) {
            logger.warning("bad input, null strategy: " + pipeline);
            return false;
        }
        PipelineStrategyJenkins jenkins = strategy.getJenkins();
        return jenkins != null && (StringUtils.isNotEmpty((String)jenkins.getJenkinsfile()) || StringUtils.isNotEmpty((String)jenkins.getJenkinsfilePath()));
    }

    public static boolean isPipelineStrategyPipelineConfig(PipelineConfig pc) {
        if (pc == null) {
            return false;
        }
        PipelineStrategy strategy = pc.getSpec().getStrategy();
        if (strategy == null) {
            return false;
        }
        PipelineStrategyJenkins jenkins = strategy.getJenkins();
        if (jenkins == null) {
            return false;
        }
        return StringUtils.isNotEmpty((String)jenkins.getJenkinsfile()) || StringUtils.isNotEmpty((String)jenkins.getJenkinsfilePath());
    }

    public static String jenkinsJobName(PipelineConfig pc) {
        String namespace = pc.getMetadata().getNamespace();
        String name = pc.getMetadata().getName();
        return AlaudaUtils.jenkinsJobName(namespace, name);
    }

    public static String jenkinsJobName(String namespace, String pipelineConfigName) {
        return namespace + "-" + pipelineConfigName;
    }

    public static String jenkinsJobFullName(PipelineConfig pc) {
        String jobName = AlaudaUtils.getAnnotation((HasMetadata)pc, "jenkins.alauda.io/job-path");
        if (StringUtils.isNotBlank((String)jobName)) {
            return jobName;
        }
        return AlaudaUtils.getNamespace((HasMetadata)pc) + "/" + AlaudaUtils.getName((HasMetadata)pc);
    }

    public static ItemGroup getFullNameParent(Jenkins activeJenkins, String fullName, String namespace) {
        int idx = fullName.lastIndexOf(47);
        if (idx > 0) {
            String parentFullName = fullName.substring(0, idx);
            Item parent = activeJenkins.getItemByFullName(parentFullName);
            if (parent instanceof ItemGroup) {
                return (ItemGroup)parent;
            }
            if (parentFullName.equals(namespace)) {
                Folder folder = new Folder((ItemGroup)activeJenkins, namespace);
                try {
                    folder.setDescription("Folder for the Alauda DevOps project: " + namespace);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BulkChange bk = new BulkChange((Saveable)folder);
                StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)folder));
                try {
                    activeJenkins.createProjectFromXML(namespace, (InputStream)jobStream).save();
                }
                catch (IOException e) {
                    logger.warning("Failed to create the Folder: " + namespace);
                }
                try {
                    bk.commit();
                }
                catch (IOException e) {
                    logger.warning("Failed to commit toe BulkChange for the Folder: " + namespace);
                }
                parent = activeJenkins.getItemByFullName(namespace);
                if (parent instanceof ItemGroup) {
                    return (ItemGroup)parent;
                }
            }
        }
        return activeJenkins;
    }

    public static String jenkinsJobDisplayName(PipelineConfig pc) {
        String namespace = pc.getMetadata().getNamespace();
        String name = pc.getMetadata().getName();
        return AlaudaUtils.jenkinsJobDisplayName(namespace, name);
    }

    public static String jenkinsJobDisplayName(String namespace, String pipelineConfigName) {
        return namespace + "/" + pipelineConfigName;
    }

    public static String[] getNamespaceOrUseDefault(String configuredJenkinsService, AlaudaDevOpsClient client) {
        ArrayList<String> namespaces = new ArrayList<String>();
        if (configuredJenkinsService == null || configuredJenkinsService.isEmpty()) {
            logger.fine("No jenkins service configured... will look using jenkins host...");
            String jenkinsHost = AlaudaUtils.getJenkinsURL(client, null);
            if (jenkinsHost != null && !jenkinsHost.isEmpty()) {
                JenkinsList jenkinsList = (JenkinsList)client.jenkins().list();
                if (jenkinsList.getItems() != null && jenkinsList.getItems().size() > 0) {
                    for (io.alauda.kubernetes.api.model.Jenkins jen : jenkinsList.getItems()) {
                        if (!jenkinsHost.equals(jen.getSpec().getHttp().getHost())) continue;
                        configuredJenkinsService = jen.getMetadata().getName();
                        logger.fine("Found correct jenkins service: " + jen.getMetadata().getName());
                        break;
                    }
                }
            } else {
                logger.warning("Could not get a jenkins host address for search... Please setup the Jenkins host address or adjust settings to the given Jenkins Service in Alauda DevOps");
            }
        }
        if (configuredJenkinsService != null && !configuredJenkinsService.isEmpty()) {
            logger.fine("Looking for bindings for the jenkins instance " + configuredJenkinsService + "...");
            JenkinsBindingList jenkinsBindingList = (JenkinsBindingList)((FilterWatchListMultiDeletable)client.jenkinsBindings().inAnyNamespace()).list();
            if (jenkinsBindingList != null && jenkinsBindingList.getItems() != null && jenkinsBindingList.getItems().size() > 0) {
                for (JenkinsBinding binding : jenkinsBindingList.getItems()) {
                    String namespace;
                    if (!configuredJenkinsService.equals(binding.getSpec().getJenkins().getName()) || namespaces.contains(namespace = binding.getMetadata().getNamespace())) continue;
                    namespaces.add(namespace);
                }
            }
        } else {
            logger.warning("Jenkins service name was not set. Please set the name of the service in the Jenkins configuration. It must be the same as in the Alauda DevOps.");
        }
        return namespaces.toArray(new String[0]);
    }

    public static String getExternalServiceUrl(AlaudaDevOpsClient alaudaClient, String defaultProtocolText, String namespace, String serviceName) {
        return defaultProtocolText + serviceName;
    }

    public static String getJenkinsURL(AlaudaDevOpsClient alaudaDevOpsClient, String namespace) {
        String rootUrl = null;
        return rootUrl;
    }

    public static String getNamespacefromPodInputs() {
        return jenkinsPodNamespace;
    }

    public static void updateGitSourceUrl(PipelineConfig pipelineConfig, String gitUrl, String ref) {
        PipelineSourceGit git;
        PipelineSource source;
        PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec == null) {
            spec = new PipelineConfigSpec();
            pipelineConfig.setSpec(spec);
        }
        if ((source = spec.getSource()) == null) {
            source = new PipelineSource();
            spec.setSource(source);
        }
        if ((git = source.getGit()) == null) {
            git = new PipelineSourceGit();
            source.setGit(git);
        }
        git.setUri(gitUrl);
        git.setRef(ref);
    }

    public static void updatePipelinePhase(Pipeline pipeline, String phase) {
        logger.log(Level.FINE, "setting pipeline to {0} in namespace {1}/{2}", new Object[]{phase, pipeline.getMetadata().getNamespace(), pipeline.getMetadata().getName()});
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            logger.severe("Can't found alauda client.");
            return;
        }
        String namespace = pipeline.getMetadata().getNamespace();
        String name = pipeline.getMetadata().getName();
        Pipeline pipe = (Pipeline)((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(name)).get();
        if (pipe == null) {
            logger.warning(() -> "Can't find Pipeline by namespace: " + namespace + ", name: " + name);
            return;
        }
        PipelineStatus stats = pipe.getStatus();
        if (stats == null) {
            stats = new PipelineStatusBuilder().build();
        }
        stats.setPhase(phase);
        pipe.setStatus(stats);
        ((PipelineResource)((NonNamespaceOperation)client.pipelines().inNamespace(namespace)).withName(name)).patch((Object)pipe);
    }

    public static NamespaceName buildConfigNameFromJenkinsJobName(String jobName, String namespace) {
        return new NamespaceName(namespace, jobName);
    }

    public static NamespaceName pipelineConfigNameFromJenkinsJobName(String jobName, String namespace) {
        return new NamespaceName(namespace, jobName);
    }

    public static long parseResourceVersion(HasMetadata obj) {
        return AlaudaUtils.parseResourceVersion(obj.getMetadata().getResourceVersion());
    }

    public static long parseResourceVersion(String resourceVersion) {
        try {
            return Long.parseLong(resourceVersion);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String formatTimestamp(long timestamp) {
        return dateFormatter.print((ReadableInstant)new DateTime(timestamp));
    }

    public static String getCurrentTimestamp() {
        return dateFormatter.print((ReadableInstant)new DateTime());
    }

    public static long parseTimestamp(String timestamp) {
        return dateFormatter.parseMillis(timestamp);
    }

    public static boolean isCancellable(PipelineStatus pipelineStatus) {
        String phase = pipelineStatus.getPhase();
        return phase.equals("Queued") || phase.equals("Pending") || phase.equals("Running");
    }

    public static boolean isNew(PipelineStatus pipelineStatus) {
        return pipelineStatus.getPhase().equals("Pending");
    }

    public static boolean isCancelled(PipelineStatus status) {
        return status != null && status.getAborted() != false;
    }

    public static String convertNameToValidResourceName(String text) {
        String lower = text.toLowerCase();
        StringBuilder builder = new StringBuilder();
        boolean started = false;
        int lastCh = 32;
        int last = lower.length() - 1;
        for (int i = 0; i <= last; ++i) {
            int ch = lower.charAt(i);
            if (!(ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57)) {
                if (ch == 47) {
                    ch = 46;
                } else if (ch != 46 && ch != 45) {
                    ch = 45;
                }
                if (!started || lastCh == 45 || lastCh == 46 || i == last) continue;
            }
            builder.append((char)ch);
            started = true;
            lastCh = ch;
        }
        return builder.toString();
    }

    public static String getAnnotation(HasMetadata resource, String name) {
        Map annotations;
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null && (annotations = metadata.getAnnotations()) != null) {
            return (String)annotations.get(name);
        }
        return null;
    }

    public static void addAnnotation(HasMetadata resource, String name, String value) {
        HashMap<String, String> annotations;
        ObjectMeta metadata = resource.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            resource.setMetadata(metadata);
        }
        if ((annotations = metadata.getAnnotations()) == null) {
            annotations = new HashMap<String, String>();
            metadata.setAnnotations(annotations);
        }
        annotations.put(name, value);
    }

    public static String getNamespace(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null) {
            return metadata.getNamespace();
        }
        return null;
    }

    public static String getName(HasMetadata resource) {
        ObjectMeta metadata = resource.getMetadata();
        if (metadata != null) {
            return metadata.getName();
        }
        return null;
    }

    public static boolean isBindingToCurrentJenkins(JenkinsBinding jenkinsBinding) {
        AlaudaSyncGlobalConfiguration pluginConfig = AlaudaSyncGlobalConfiguration.get();
        String jenkinsName = jenkinsBinding.getSpec().getJenkins().getName();
        String jenkinsService = pluginConfig.getJenkinsService();
        return jenkinsName.equals(jenkinsService);
    }

    public static boolean isBindingToCurrentJenkins(String namespace) {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            logger.severe("Can't found alauda client.");
            return false;
        }
        String jenkinsService = AlaudaSyncGlobalConfiguration.get().getJenkinsService();
        JenkinsBindingList jenkinsBindings = (JenkinsBindingList)((NonNamespaceOperation)client.jenkinsBindings().inNamespace(namespace)).list();
        if (jenkinsBindings != null) {
            for (JenkinsBinding binding : jenkinsBindings.getItems()) {
                if (!binding.getSpec().getJenkins().getName().equals(jenkinsService)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        jenkinsPodNamespace = null;
        jenkinsPodNamespace = System.getProperty("PROJECT_NAME");
        if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
            jenkinsPodNamespace = jenkinsPodNamespace.trim();
        } else {
            File f = new File("/run/secrets/kubernetes.io/serviceaccount/namespace");
            if (f.exists()) {
                try (FileReader fr = new FileReader("/run/secrets/kubernetes.io/serviceaccount/namespace");
                     BufferedReader br = new BufferedReader(fr);){
                    jenkinsPodNamespace = br.readLine();
                    if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
                        jenkinsPodNamespace = jenkinsPodNamespace.trim();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
            }
        }
        dateFormatter = ISODateTimeFormat.dateTimeNoMillis();
    }

    abstract class ObjectMetaMixIn
    extends ObjectMeta {
        @JsonIgnore
        private String creationTimestamp;
        @JsonIgnore
        private String deletionTimestamp;
        @JsonIgnore
        private Long generation;
        @JsonIgnore
        private String resourceVersion;
        @JsonIgnore
        private String selfLink;
        @JsonIgnore
        private String uid;

        ObjectMetaMixIn() {
        }

        @JsonIgnore
        public abstract String getCreationTimestamp();

        @JsonIgnore
        public abstract String getDeletionTimestamp();

        @JsonIgnore
        public abstract Long getGeneration();

        @JsonIgnore
        public abstract String getResourceVersion();

        @JsonIgnore
        public abstract String getSelfLink();

        @JsonIgnore
        public abstract String getUid();
    }

    abstract class StatelessReplicationControllerMixIn
    extends ReplicationController {
        @JsonIgnore
        private ReplicationControllerStatus status;

        StatelessReplicationControllerMixIn() {
        }

        @JsonIgnore
        public abstract ReplicationControllerStatus getStatus();
    }
}

