/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.action;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.util.HttpResponses;
import io.alauda.devops.client.AlaudaDevOpsConfig;
import io.alauda.devops.client.AlaudaDevOpsConfigBuilder;
import io.alauda.devops.client.DefaultAlaudaDevOpsClient;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.CronUtils;
import io.alauda.kubernetes.client.Config;
import io.alauda.kubernetes.client.KubernetesClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.apache.http.HttpRequest;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@Extension
@Symbol(value={"alauda"})
@ExportedBean
public class KubernetesClientAction
implements UnprotectedRootAction {
    private static final Logger logger = Logger.getLogger(KubernetesClientAction.class.getName());

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Kubernetes connect test";
    }

    @CheckForNull
    public String getUrlName() {
        return "alauda";
    }

    public HttpResponse doConnectTest(@QueryParameter String server, @QueryParameter String credentialId) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.connectTest(server, credentialId);
            result.put("success", "true");
            result.put("message", "ok");
        }
        catch (KubernetesClientException e) {
            result.put("success", "false");
            result.put("message", e.getMessage());
        }
        return HttpResponses.okJSON(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Exported
    public HttpResponse doBuildId() {
        Properties pro = new Properties();
        ClassLoader loader = KubernetesClientAction.class.getClassLoader();
        try (InputStream stream = loader.getResourceAsStream("debug.properties");){
            if (stream == null) return HttpResponses.errorJSON((String)"no debug file");
            pro.load(stream);
            HttpResponse httpResponse = HttpResponses.okJSON((Map)pro);
            return httpResponse;
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        return HttpResponses.errorJSON((String)"no debug file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doCronTabCheck(HttpRequest request, @QueryParameter String cronText) {
        HashMap<String, String> result = new HashMap<String, String>();
        Locale defaultLocale = Locale.getDefault();
        try {
            CronUtils cron = CronUtils.create(cronText, null);
            Calendar next = cron.next();
            Calendar previous = cron.previous();
            if (next != null) {
                result.put("next", String.valueOf(next.getTimeInMillis()));
            }
            if (previous != null) {
                result.put("previous", String.valueOf(previous.getTimeInMillis()));
            }
            Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
            result.put("sanity_" + Locale.SIMPLIFIED_CHINESE, cron.checkSanity());
            Locale.setDefault(Locale.ENGLISH);
            result.put("sanity_" + Locale.ENGLISH, cron.checkSanity());
        }
        catch (ANTLRException e) {
            logger.warning(String.format("cron text syntax check error: %s.", e.getMessage()));
            result.put("error", e.getMessage());
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
        return HttpResponses.okJSON(result);
    }

    public URL connectTest(String server, String credentialId) {
        String token;
        AlaudaDevOpsConfigBuilder configBuilder = new AlaudaDevOpsConfigBuilder();
        if (server != null && !server.isEmpty()) {
            configBuilder.withMasterUrl(server);
        }
        AlaudaDevOpsConfig config = configBuilder.build();
        DefaultAlaudaDevOpsClient client = new DefaultAlaudaDevOpsClient((Config)config);
        if (credentialId != null && (token = CredentialsUtils.getToken(credentialId)) != null) {
            client.getConfiguration().setOauthToken(token);
        }
        client.namespaces().list();
        return client.getMasterUrl();
    }
}

