/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import io.alauda.devops.client.AlaudaDevOpsClient;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.listener.PipelineSyncRunListener;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.PipelineGenerator;
import io.alauda.jenkins.devops.sync.util.PipelineToActionMapper;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import io.alauda.kubernetes.api.model.Pipeline;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.client.KubernetesClientException;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class PipelineDecisionHandler
extends Queue.QueueDecisionHandler {
    private static final Logger LOGGER = Logger.getLogger(PipelineDecisionHandler.class.getName());

    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        if (p instanceof WorkflowJob && PipelineDecisionHandler.triggerFromJenkins(actions)) {
            Pipeline pipeline;
            WorkflowJob workflowJob = (WorkflowJob)p;
            String taskName = p.getName();
            PipelineConfigProjectProperty pipelineConfigProjectProperty = (PipelineConfigProjectProperty)workflowJob.getProperty(PipelineConfigProjectProperty.class);
            if (pipelineConfigProjectProperty == null || !this.hasValidProperty(workflowJob)) {
                return true;
            }
            String namespace = pipelineConfigProjectProperty.getNamespace();
            String name = pipelineConfigProjectProperty.getName();
            String jobURL = this.getJobUrl(workflowJob, namespace);
            LOGGER.info(() -> "Got this namespace " + namespace + " from this pipelineConfigProjectProperty: " + name);
            PipelineConfig config = null;
            try {
                config = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(namespace)).withName(name)).get();
            }
            catch (KubernetesClientException e) {
                LOGGER.warning(() -> e.getMessage() + "; cause: " + e.getCause().getMessage());
            }
            if (config == null) {
                return false;
            }
            if (config.getMetadata() == null) {
                LOGGER.warning("PipelineConfig metadata is null");
                return false;
            }
            try {
                pipeline = PipelineGenerator.buildPipeline(config, jobURL, actions);
            }
            catch (KubernetesClientException e) {
                LOGGER.warning(config.getMetadata().getName() + " got error : " + e.getMessage());
                if (e.getCode() == 409) {
                    PipelineUtils.pipelinesCheck(config);
                }
                return false;
            }
            ParametersAction params = PipelineDecisionHandler.dumpParams(actions);
            if (params != null) {
                LOGGER.fine(() -> "ParametersAction: " + params.toString());
                PipelineToActionMapper.addParameterAction(pipeline.getMetadata().getName(), params);
            } else {
                LOGGER.log(Level.FINE, "The param is null in task : {0}", taskName);
            }
            CauseAction cause = this.dumpCause(actions);
            if (cause != null) {
                LOGGER.fine(() -> "get CauseAction: " + cause.getDisplayName());
                for (Cause c : cause.getCauses()) {
                    LOGGER.fine(() -> "Cause: " + c.getShortDescription());
                }
                PipelineToActionMapper.addCauseAction(pipeline.getMetadata().getName(), cause);
            } else {
                LOGGER.fine(() -> "Get null CauseAction in task : " + taskName);
            }
            return false;
        }
        return true;
    }

    private String getJobUrl(WorkflowJob workflowJob, String namespace) {
        AlaudaDevOpsClient client = AlaudaUtils.getAuthenticatedAlaudaClient();
        if (client == null) {
            return null;
        }
        String jenkinsUrl = AlaudaUtils.getJenkinsURL(client, namespace);
        return PipelineSyncRunListener.joinPaths(jenkinsUrl, workflowJob.getUrl());
    }

    private boolean hasValidProperty(WorkflowJob workflowJob) {
        PipelineConfigProjectProperty property = (PipelineConfigProjectProperty)workflowJob.getProperty(PipelineConfigProjectProperty.class);
        if (property == null) {
            return false;
        }
        return StringUtils.isNotBlank((String)property.getNamespace()) && StringUtils.isNotBlank((String)property.getName());
    }

    private static boolean triggerFromJenkins(@Nonnull List<Action> actions) {
        return !PipelineDecisionHandler.triggerFromPlatform(actions);
    }

    private static boolean triggerFromPlatform(@Nonnull List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            for (Cause cause : causeAction.getCauses()) {
                if (!(cause instanceof JenkinsPipelineCause)) continue;
                return true;
            }
        }
        return false;
    }

    private CauseAction dumpCause(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (Cause cause : causeAction.getCauses()) {
                    LOGGER.fine(() -> "cause: " + cause.getShortDescription());
                }
            }
            return causeAction;
        }
        return null;
    }

    private static ParametersAction dumpParams(List<Action> actions) {
        for (Action action : actions) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction paramAction = (ParametersAction)action;
            if (LOGGER.isLoggable(Level.FINE)) {
                for (ParameterValue param : paramAction.getAllParameters()) {
                    LOGGER.fine(() -> "param name " + param.getName() + " param value " + param.getValue());
                }
            }
            return paramAction;
        }
        return null;
    }
}

