/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import io.alauda.devops.client.dsl.PipelineConfigResource;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.kubernetes.api.model.PipelineConfig;
import io.alauda.kubernetes.client.dsl.NonNamespaceOperation;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

public class PipelineConfigProjectProperty
extends JobProperty<Job<?, ?>> {
    private String uid;
    private String namespace;
    private String name;
    private String resourceVersion;

    @DataBoundConstructor
    public PipelineConfigProjectProperty(String namespace, String name, String uid, String resourceVersion) {
        this.namespace = namespace;
        this.name = name;
        this.uid = uid;
        this.resourceVersion = resourceVersion;
    }

    public PipelineConfigProjectProperty(PipelineConfig pc) {
        this(pc.getMetadata().getNamespace(), pc.getMetadata().getName(), pc.getMetadata().getUid(), pc.getMetadata().getResourceVersion());
    }

    public PipelineConfig getPipelineConfig() {
        PipelineConfig pc = (PipelineConfig)((PipelineConfigResource)((NonNamespaceOperation)AlaudaUtils.getAuthenticatedAlaudaClient().pipelineConfigs().inNamespace(this.namespace)).withName(this.name)).get();
        if (pc != null && pc.getMetadata().getUid().equals(this.uid)) {
            return pc;
        }
        return null;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return WorkflowJob.class.isAssignableFrom(jobType);
        }
    }
}

