/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractBranchBuildStrategy;
import hudson.plugins.git.GitChangeSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

abstract class AbstractRegionBranchBuildStrategy
extends AbstractBranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(AbstractRegionBranchBuildStrategy.class.getName());

    protected AbstractRegionBranchBuildStrategy(AbstractBranchBuildStrategy.Strategy strategy) {
        super(strategy);
    }

    @Override
    Set<String> getExpressions(List<GitChangeSet> changeSets) {
        HashSet<String> paths = new HashSet<String>();
        for (GitChangeSet changeSet : changeSets) {
            Collection affectedFiles = changeSet.getAffectedFiles();
            for (GitChangeSet.Path path : affectedFiles) {
                paths.add(path.getPath());
                LOGGER.fine(() -> "File: " + path.getPath() + " from commit: " + changeSet.getCommitId() + "; change type:" + path.getEditType().getName());
            }
        }
        return paths;
    }
}

