/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.google.common.annotations.VisibleForTesting;
import com.igalg.jenkins.plugins.multibranch.buildstrategy.BranchBuildStrategyHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.SCM;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.branch.BranchBuildStrategy;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;

public abstract class AbstractBranchBuildStrategy
extends BranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(AbstractBranchBuildStrategy.class.getName());
    private final Strategy strategy;

    protected AbstractBranchBuildStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, SCMRevision lastBuiltRevision, SCMRevision lastSeenRevision, @NonNull TaskListener listener) {
        try {
            SCMSourceOwner owner = source.getOwner();
            if (owner == null) {
                LOGGER.severe("Error verify SCM source owner");
                return true;
            }
            SCM scm = source.build(head, currRevision);
            SCMFileSystem fileSystem = BranchBuildStrategyHelper.buildSCMFileSystem(source, head, currRevision, scm, owner);
            if (fileSystem == null) {
                LOGGER.severe("Error build SCM file system");
                return true;
            }
            Set<String> patterns = this.getPatterns(fileSystem);
            if (patterns.isEmpty()) {
                boolean build = this.strategy == Strategy.EXCLUDED;
                LOGGER.info(() -> String.format("No pattern with strategy: %s, building=%s", new Object[]{this.strategy, build}));
                return build;
            }
            List<GitChangeSet> changeSets = BranchBuildStrategyHelper.getGitChangeSetList(fileSystem, head, lastBuiltRevision);
            Set<String> expressions = this.getExpressions(changeSets);
            LOGGER.fine(() -> String.format("Strategy: %s, patterns: [%s], expressions: [%s]", new Object[]{this.strategy, String.join((CharSequence)", ", patterns), String.join((CharSequence)", ", expressions)}));
            return this.shouldRunBuild(patterns, expressions);
        }
        catch (Exception e) {
            LOGGER.severe("Unexpected exception: " + e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    @VisibleForTesting
    abstract Set<String> getPatterns(SCMFileSystem var1);

    @VisibleForTesting
    abstract Set<String> getExpressions(List<GitChangeSet> var1);

    @VisibleForTesting
    abstract boolean shouldRunBuild(Set<String> var1, Set<String> var2);

    public static enum Strategy {
        INCLUDED,
        EXCLUDED;

    }
}

