/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.webload;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class WebLoadConsoleBuilder
extends Builder {
    private final String tplFile;
    private final String lsFile;
    private final long executionDuration;
    private final long virtualClients;
    private final long probindClient;
    private static final String[] sessionExtensions = new String[]{"ls", "dat", "isd", "mdb", "sdb"};

    public String getTplFile() {
        return this.tplFile;
    }

    public String getLsFile() {
        return this.lsFile;
    }

    public long getExecutionDuration() {
        return this.executionDuration;
    }

    public long getVirtualClients() {
        return this.virtualClients;
    }

    public long getProbindClient() {
        return this.probindClient;
    }

    @DataBoundConstructor
    public WebLoadConsoleBuilder(String tplFile, String lsFile, long executionDuration, long virtualClients, long probindClient) {
        this.tplFile = tplFile;
        this.lsFile = lsFile;
        this.executionDuration = executionDuration;
        this.virtualClients = virtualClients;
        this.probindClient = probindClient;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            envVars.put((String)e.getKey(), (String)e.getValue());
        }
        String path = (String)envVars.get((Object)"WL_HOME");
        if (path != null && path.length() > 0) {
            listener.getLogger().println("Using WL_HOME:" + path);
        } else {
            path = this.getDescriptor().getWebloadInstallationPath();
            if (path != null && path.length() > 0) {
                listener.getLogger().println("Using WebloadInstallationPath:" + path);
            } else {
                String programFile = (String)envVars.get((Object)"ProgramFiles(x86)");
                if (programFile == null) {
                    programFile = (String)envVars.get((Object)"ProgramFiles");
                }
                if (programFile == null) {
                    programFile = "C:\\Program Files";
                }
                path = programFile + "\\RadView\\WebLOAD";
            }
        }
        String execName = "webload.exe";
        String webloadExecPath = path + "\\bin\\" + execName;
        if (this.tplFile == null || this.tplFile.isEmpty()) {
            throw new AbortException("Template file not specified");
        }
        String tplFileName = envVars.expand(this.tplFile);
        String lsFileName = this.lsFile;
        if (lsFileName == null || lsFileName.isEmpty()) {
            lsFileName = this.tplFile;
        }
        lsFileName = WebLoadConsoleBuilder.replaceExtension(lsFileName, "ls");
        lsFileName = envVars.expand(lsFileName);
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("Unexpected error, workspace not configured");
        }
        FilePath lsFilePath = new FilePath(workspace, lsFileName);
        FilePath resultsFile = workspace.child("results.xml");
        if (resultsFile.exists()) {
            resultsFile.delete();
        }
        args.add(webloadExecPath);
        args.add(tplFileName);
        args.add((Object)lsFilePath);
        if (this.virtualClients > 0L) {
            args.add("/vc");
            args.add((Object)this.virtualClients);
        }
        if (this.probindClient > 0L) {
            args.add("/pc");
            args.add((Object)this.probindClient);
        }
        args.add("/ar");
        if (this.executionDuration > 0L) {
            args.add((Object)this.executionDuration);
        }
        args.add("/rc");
        args.add((Object)resultsFile);
        ArgumentListBuilder winCmd = args;
        listener.getLogger().println("Executing the command " + winCmd.toStringWithQuote());
        int result = launcher.launch().cmds(winCmd).stdout((TaskListener)listener).envs((Map)envVars).join();
        listener.getLogger().println("Execution ended, parsing return code");
        if (!resultsFile.exists()) {
            throw new AbortException("WebLOADO session ended unexpectedely. Result file not created");
        }
        String r = resultsFile.readToString();
        listener.getLogger().println(r);
        String sessionReturnCode = WebLoadConsoleBuilder.extractValue("SessionReturnCode=\"", "\"", r);
        String errorDescription = WebLoadConsoleBuilder.extractValue("ErrorDescription=\"", "\"", r);
        listener.getLogger().println("SessionReturnCode " + sessionReturnCode);
        listener.getLogger().println("ErrorDescription " + errorDescription);
        if (!"Passed".equalsIgnoreCase(sessionReturnCode)) {
            build.setResult(Result.UNSTABLE);
        }
        if (!lsFilePath.exists()) {
            throw new AbortException("WebLOADO session ended unexpectedely. Load Session file not created");
        }
        if (new File(lsFileName).isAbsolute()) {
            listener.getLogger().println("Not archiving from absolute path");
        } else {
            HashMap<String, String> files = new HashMap<String, String>();
            for (String e : sessionExtensions) {
                String f = WebLoadConsoleBuilder.replaceExtension(lsFileName, e);
                f = f.replace(File.separatorChar, '/');
                listener.getLogger().println("Archiving " + f);
                files.put(f, f);
            }
            try {
                build.pickArtifactManager().archive(workspace, launcher, listener, files);
            }
            catch (IOException e1) {
                listener.getLogger().println("Error archiving files: " + e1.getLocalizedMessage());
            }
        }
        return result == 0;
    }

    static String extractValue(String prefix, String suffix, String str) {
        Pattern p = Pattern.compile("(" + prefix + ")(.*)(" + suffix + ")");
        Matcher m = p.matcher(str);
        if (!m.find()) {
            return null;
        }
        if (m.groupCount() < 2) {
            return null;
        }
        return m.group(2);
    }

    public ConsoleDescriptor getDescriptor() {
        return (ConsoleDescriptor)super.getDescriptor();
    }

    static String replaceExtension(String name, String extension) {
        int ext = name.lastIndexOf(".");
        if (ext > 0) {
            return name.substring(0, ext) + "." + extension;
        }
        return name + "." + extension;
    }

    @Extension
    public static final class ConsoleDescriptor
    extends BuildStepDescriptor<Builder> {
        private String webloadInstallationPath;

        public ConsoleDescriptor() {
            super(WebLoadConsoleBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return "Execute WebLOAD load session";
        }

        public FormValidation doCheckTplFile(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please select a template file");
            }
            if (!value.endsWith(".tpl")) {
                return FormValidation.warning((String)"File extension is not tpl, is this the right file?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExecutionDuration(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.length() == 0) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)"Please select a number");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            formData = formData.getJSONObject("webload");
            this.webloadInstallationPath = formData.getString("webloadInstallationPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getWebloadInstallationPath() {
            return this.webloadInstallationPath;
        }
    }
}

