/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.webload;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class WebLoadAnalyticsBuilder
extends Builder {
    private final String inputLsFile;
    private final String portfolioFile;
    private final OutputFormats format;
    private final String location;
    private final String reportName;
    private final String compareToSessions;
    private final int compareToPreviousBuilds;

    @DataBoundConstructor
    public WebLoadAnalyticsBuilder(String inputLsFile, String portfolioFile, OutputFormats format, String location, String reportName, String compareToSessions, int compareToPreviousBuilds) {
        this.inputLsFile = inputLsFile;
        this.portfolioFile = portfolioFile;
        this.format = format;
        this.location = location;
        this.reportName = reportName;
        this.compareToSessions = compareToSessions;
        this.compareToPreviousBuilds = compareToPreviousBuilds;
    }

    public String getInputLsFile() {
        return this.inputLsFile;
    }

    public String getPortfolioFile() {
        return this.portfolioFile;
    }

    public OutputFormats getFormat() {
        return this.format;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getCompareToSessions() {
        return this.compareToSessions;
    }

    public int getCompareToPreviousBuilds() {
        return this.compareToPreviousBuilds;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            envVars.put((String)e.getKey(), (String)e.getValue());
        }
        String path = (String)envVars.get((Object)"WL_HOME");
        if (path != null && path.length() > 0) {
            listener.getLogger().println("Using WL_HOME:" + path);
        } else {
            path = this.getDescriptor().getWebloadInstallationPath();
            if (path != null && path.length() > 0) {
                listener.getLogger().println("Using WebloadInstallationPath:" + path);
            } else {
                String programFile = (String)envVars.get((Object)"ProgramFiles(x86)");
                if (programFile == null) {
                    programFile = (String)envVars.get((Object)"ProgramFiles");
                }
                if (programFile == null) {
                    programFile = "C:\\Program Files";
                }
                path = programFile + "\\RadView\\WebLOAD";
            }
        }
        String execName = "WLAnalyticsCmd.exe";
        String analyticsExecPath = path + "\\bin\\" + execName;
        FilePath webloadFile = new FilePath(launcher.getChannel(), analyticsExecPath);
        if (!webloadFile.exists()) {
            throw new AbortException("Can't find installation at " + analyticsExecPath);
        }
        String inputFsFileName = build.getEnvironment((TaskListener)listener).expand(this.inputLsFile);
        FilePath lsFilePath = new FilePath(build.getWorkspace(), inputFsFileName);
        if (!lsFilePath.exists()) {
            throw new AbortException("Can't find Load Session file " + lsFilePath);
        }
        ArrayList<FilePath> sessionsToCompare = new ArrayList<FilePath>();
        if (this.compareToSessions != null && !this.compareToSessions.isEmpty()) {
            String[] splitSessions;
            for (String s : splitSessions = this.compareToSessions.split(",")) {
                FilePath compareSessionFilePath = new FilePath(build.getWorkspace(), build.getEnvironment((TaskListener)listener).expand(s));
                sessionsToCompare.add(compareSessionFilePath);
                if (compareSessionFilePath.exists()) {
                    listener.getLogger().println("Add LS for comparison " + compareSessionFilePath);
                    continue;
                }
                listener.getLogger().println("WARN : LS for comparison not found " + compareSessionFilePath);
            }
        }
        AbstractBuild previousBuild = build.getPreviousBuild();
        for (int prevBuilds = this.compareToPreviousBuilds; prevBuilds > 0 && previousBuild != null; previousBuild = previousBuild.getPreviousBuild(), --prevBuilds) {
            File artifactsDir = previousBuild.getArtifactsDir();
            String previousLsName = previousBuild.getEnvironment((TaskListener)listener).expand(this.inputLsFile);
            listener.getLogger().println("Looking for " + previousLsName);
            File previousLsFile = new File(artifactsDir, previousLsName);
            FilePath previousLsFilePath = new FilePath(build.getWorkspace(), previousLsFile.getPath());
            if (previousLsFilePath.exists()) {
                sessionsToCompare.add(previousLsFilePath);
                listener.getLogger().println("Add previous LS for comparison from artifacts " + previousLsFile.getAbsolutePath());
                continue;
            }
            previousLsFilePath = new FilePath(build.getWorkspace(), previousLsName);
            if (previousLsFilePath.exists()) {
                sessionsToCompare.add(previousLsFilePath);
                listener.getLogger().println("Add previous LS for comparison from workspace " + previousLsFilePath);
                continue;
            }
            listener.getLogger().println("Not found previous LS from build " + previousBuild);
        }
        args.add(analyticsExecPath);
        args.add("-m");
        args.add("U");
        args.add("-p");
        if (this.portfolioFile != null && !this.portfolioFile.isEmpty()) {
            args.add(this.portfolioFile);
        } else {
            args.add("Summary Portfolio");
        }
        args.add("-ls");
        args.add((Object)lsFilePath);
        for (FilePath compareSess : sessionsToCompare) {
            args.add("-ls");
            args.add((Object)compareSess);
        }
        if (this.format != null) {
            args.add("-f");
            args.add(this.format.name());
        }
        args.add("-l");
        if (this.location != null && !this.location.isEmpty()) {
            args.add(this.location);
        } else {
            args.add((Object)build.getWorkspace());
        }
        if (this.reportName != null && !this.reportName.isEmpty()) {
            args.add("-n");
            args.add(this.reportName);
        }
        ArgumentListBuilder winCmd = args.toWindowsCommand();
        listener.getLogger().println("Executing the command " + winCmd.toStringWithQuote());
        int result = launcher.launch().cmds(winCmd).stdout((TaskListener)listener).envs((Map)envVars).join();
        listener.getLogger().println("Execution ended");
        return result == 0;
    }

    public AnalyticsDescriptor getDescriptor() {
        return (AnalyticsDescriptor)super.getDescriptor();
    }

    @Extension
    public static final class AnalyticsDescriptor
    extends BuildStepDescriptor<Builder> {
        private String webloadInstallationPath;

        public AnalyticsDescriptor() {
            super(WebLoadAnalyticsBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return "Generate WebLOAD Analytics Report";
        }

        public FormValidation doCheckInputLsFile(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please select a load session file");
            }
            if (!value.endsWith(".ls")) {
                return FormValidation.warning((String)"File extension is not .ls, is this the right file?");
            }
            return FormValidation.ok();
        }

        public ComboBoxModel doFillPortfolioFileItems() {
            return new ComboBoxModel(new String[]{"Summray Portfolio", "Session Comparison Portfolio", "Extended Summary Portfolio"});
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            formData = formData.getJSONObject("webload");
            this.webloadInstallationPath = formData.getString("webloadInstallationPath");
            this.save();
            return super.configure(req, formData);
        }

        public String getWebloadInstallationPath() {
            return this.webloadInstallationPath;
        }
    }

    public static enum OutputFormats {
        JUNIT,
        HTML,
        DOC,
        ODT,
        XLS,
        XLSX,
        RTF,
        PDF,
        CSV,
        RAW;

    }
}

