/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.signal_killer;

import hudson.Extension;
import hudson.util.ProcessKiller;
import hudson.util.ProcessTree;
import hudson.util.jna.GNUCLibrary;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class SignalKiller
extends ProcessKiller {
    public static final int SIGABRT = 6;
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;
    private static final Logger LOGGER = Logger.getLogger(SignalKiller.class.getName());

    public SignalKiller() {
        LOGGER.fine("SignalKiller initialized");
    }

    public boolean kill(ProcessTree.OSProcess process) throws IOException, InterruptedException {
        try {
            int retVal = this.sendSignal(process.getPid(), 9);
            if (retVal == 0) {
                return true;
            }
        }
        catch (Error ex) {
            LOGGER.log(Level.SEVERE, "Can't kill process!", ex);
        }
        return false;
    }

    private int sendSignal(int pid, int signal) {
        LOGGER.fine("Sending signal " + signal + " to process " + pid);
        return GNUCLibrary.LIBC.kill(pid, signal);
    }
}

