// CHECKSTYLE:OFF

package fr.edf.jenkins.plugins.mac;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MacHostKeyVerifier.KeyNotTrusted}: {@code The SSH key for

     * the host {0} does not match the key required in the connection

     * configuration. Connections will be denied until the host key matches

     * the configuration key.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The SSH key for the host {0} does not match the key required in

     *     the connection configuration. Connections will be denied until the

     *     host key matches the configuration key.}
     */
    public static String MacHostKeyVerifier_KeyNotTrusted(Object arg0) {
        return holder.format("MacHostKeyVerifier.KeyNotTrusted", arg0);
    }

    /**
     * Key {@code MacHostKeyVerifier.KeyNotTrusted}: {@code The SSH key for

     * the host {0} does not match the key required in the connection

     * configuration. Connections will be denied until the host key matches

     * the configuration key.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The SSH key for the host {0} does not match the key required in

     *     the connection configuration. Connections will be denied until the

     *     host key matches the configuration key.}
     */
    public static Localizable _MacHostKeyVerifier_KeyNotTrusted(Object arg0) {
        return new Localizable(holder, "MacHostKeyVerifier.KeyNotTrusted", arg0);
    }

    /**
     * Key {@code Host.HostRequired}: {@code Host value is required}.
     * 
     * @return
     *     {@code Host value is required}
     */
    public static String Host_HostRequired() {
        return holder.format("Host.HostRequired");
    }

    /**
     * Key {@code Host.HostRequired}: {@code Host value is required}.
     * 
     * @return
     *     {@code Host value is required}
     */
    public static Localizable _Host_HostRequired() {
        return new Localizable(holder, "Host.HostRequired");
    }

    /**
     * Key {@code Cloud.Name}: {@code Name}.
     * 
     * @return
     *     {@code Name}
     */
    public static String Cloud_Name() {
        return holder.format("Cloud.Name");
    }

    /**
     * Key {@code Cloud.Name}: {@code Name}.
     * 
     * @return
     *     {@code Name}
     */
    public static Localizable _Cloud_Name() {
        return new Localizable(holder, "Cloud.Name");
    }

    /**
     * Key {@code Host.SecurityRestriction}: {@code Cannot validate the host

     * due to security restriction}.
     * 
     * @return
     *     {@code Cannot validate the host due to security restriction}
     */
    public static String Host_SecurityRestriction() {
        return holder.format("Host.SecurityRestriction");
    }

    /**
     * Key {@code Host.SecurityRestriction}: {@code Cannot validate the host

     * due to security restriction}.
     * 
     * @return
     *     {@code Cannot validate the host due to security restriction}
     */
    public static Localizable _Host_SecurityRestriction() {
        return new Localizable(holder, "Host.SecurityRestriction");
    }

    /**
     * Key {@code MacHostKeyVerifier.KeyValueDoesNotParse}: {@code Key value

     * does not parse into a valid {0} key}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Key value does not parse into a valid {0} key}
     */
    public static String MacHostKeyVerifier_KeyValueDoesNotParse(Object arg0) {
        return holder.format("MacHostKeyVerifier.KeyValueDoesNotParse", arg0);
    }

    /**
     * Key {@code MacHostKeyVerifier.KeyValueDoesNotParse}: {@code Key value

     * does not parse into a valid {0} key}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Key value does not parse into a valid {0} key}
     */
    public static Localizable _MacHostKeyVerifier_KeyValueDoesNotParse(Object arg0) {
        return new Localizable(holder, "MacHostKeyVerifier.KeyValueDoesNotParse", arg0);
    }

    /**
     * Key {@code EnvVar.Add}: {@code Add environment variable}.
     * 
     * @return
     *     {@code Add environment variable}
     */
    public static String EnvVar_Add() {
        return holder.format("EnvVar.Add");
    }

    /**
     * Key {@code EnvVar.Add}: {@code Add environment variable}.
     * 
     * @return
     *     {@code Add environment variable}
     */
    public static Localizable _EnvVar_Add() {
        return new Localizable(holder, "EnvVar.Add");
    }

    /**
     * Key {@code Host.Add}: {@code Add Mac Host}.
     * 
     * @return
     *     {@code Add Mac Host}
     */
    public static String Host_Add() {
        return holder.format("Host.Add");
    }

    /**
     * Key {@code Host.Add}: {@code Add Mac Host}.
     * 
     * @return
     *     {@code Add Mac Host}
     */
    public static Localizable _Host_Add() {
        return new Localizable(holder, "Host.Add");
    }

    /**
     * Key {@code MacSlave.NodeProperties}: {@code Node Properties}.
     * 
     * @return
     *     {@code Node Properties}
     */
    public static String MacSlave_NodeProperties() {
        return holder.format("MacSlave.NodeProperties");
    }

    /**
     * Key {@code MacSlave.NodeProperties}: {@code Node Properties}.
     * 
     * @return
     *     {@code Node Properties}
     */
    public static Localizable _MacSlave_NodeProperties() {
        return new Localizable(holder, "MacSlave.NodeProperties");
    }

    /**
     * Key {@code Host.MaxUsers}: {@code Max users}.
     * 
     * @return
     *     {@code Max users}
     */
    public static String Host_MaxUsers() {
        return holder.format("Host.MaxUsers");
    }

    /**
     * Key {@code Host.MaxUsers}: {@code Max users}.
     * 
     * @return
     *     {@code Max users}
     */
    public static Localizable _Host_MaxUsers() {
        return new Localizable(holder, "Host.MaxUsers");
    }

    /**
     * Key {@code Cloud.SuffixStartSlaveCmd}: {@code Suffix Start Agent

     * Command}.
     * 
     * @return
     *     {@code Suffix Start Agent Command}
     */
    public static String Cloud_SuffixStartSlaveCmd() {
        return holder.format("Cloud.SuffixStartSlaveCmd");
    }

    /**
     * Key {@code Cloud.SuffixStartSlaveCmd}: {@code Suffix Start Agent

     * Command}.
     * 
     * @return
     *     {@code Suffix Start Agent Command}
     */
    public static Localizable _Cloud_SuffixStartSlaveCmd() {
        return new Localizable(holder, "Cloud.SuffixStartSlaveCmd");
    }

    /**
     * Key {@code MacSlave.Description}: {@code Description}.
     * 
     * @return
     *     {@code Description}
     */
    public static String MacSlave_Description() {
        return holder.format("MacSlave.Description");
    }

    /**
     * Key {@code MacSlave.Description}: {@code Description}.
     * 
     * @return
     *     {@code Description}
     */
    public static Localizable _MacSlave_Description() {
        return new Localizable(holder, "MacSlave.Description");
    }

    /**
     * Key {@code Host.Disabled}: {@code Disabled}.
     * 
     * @return
     *     {@code Disabled}
     */
    public static String Host_Disabled() {
        return holder.format("Host.Disabled");
    }

    /**
     * Key {@code Host.Disabled}: {@code Disabled}.
     * 
     * @return
     *     {@code Disabled}
     */
    public static Localizable _Host_Disabled() {
        return new Localizable(holder, "Host.Disabled");
    }

    /**
     * Key {@code Host.HostInvalid}: {@code The given host is not valid}.
     * 
     * @return
     *     {@code The given host is not valid}
     */
    public static String Host_HostInvalid() {
        return holder.format("Host.HostInvalid");
    }

    /**
     * Key {@code Host.HostInvalid}: {@code The given host is not valid}.
     * 
     * @return
     *     {@code The given host is not valid}
     */
    public static Localizable _Host_HostInvalid() {
        return new Localizable(holder, "Host.HostInvalid");
    }

    /**
     * Key {@code Host.AgentConnectionTimeout}: {@code Agent connection

     * timeout}.
     * 
     * @return
     *     {@code Agent connection timeout}
     */
    public static String Host_AgentConnectionTimeout() {
        return holder.format("Host.AgentConnectionTimeout");
    }

    /**
     * Key {@code Host.AgentConnectionTimeout}: {@code Agent connection

     * timeout}.
     * 
     * @return
     *     {@code Agent connection timeout}
     */
    public static Localizable _Host_AgentConnectionTimeout() {
        return new Localizable(holder, "Host.AgentConnectionTimeout");
    }

    /**
     * Key {@code Host.TestConnection}: {@code Test Connection}.
     * 
     * @return
     *     {@code Test Connection}
     */
    public static String Host_TestConnection() {
        return holder.format("Host.TestConnection");
    }

    /**
     * Key {@code Host.TestConnection}: {@code Test Connection}.
     * 
     * @return
     *     {@code Test Connection}
     */
    public static Localizable _Host_TestConnection() {
        return new Localizable(holder, "Host.TestConnection");
    }

    /**
     * Key {@code MacSlave.Labels}: {@code Labels}.
     * 
     * @return
     *     {@code Labels}
     */
    public static String MacSlave_Labels() {
        return holder.format("MacSlave.Labels");
    }

    /**
     * Key {@code MacSlave.Labels}: {@code Labels}.
     * 
     * @return
     *     {@code Labels}
     */
    public static Localizable _MacSlave_Labels() {
        return new Localizable(holder, "MacSlave.Labels");
    }

    /**
     * Key {@code Host.ConnectionTimeout}: {@code Connection timeout}.
     * 
     * @return
     *     {@code Connection timeout}
     */
    public static String Host_ConnectionTimeout() {
        return holder.format("Host.ConnectionTimeout");
    }

    /**
     * Key {@code Host.ConnectionTimeout}: {@code Connection timeout}.
     * 
     * @return
     *     {@code Connection timeout}
     */
    public static Localizable _Host_ConnectionTimeout() {
        return new Localizable(holder, "Host.ConnectionTimeout");
    }

    /**
     * Key {@code Cloud.AgentsProperties}: {@code Agents Properties}.
     * 
     * @return
     *     {@code Agents Properties}
     */
    public static String Cloud_AgentsProperties() {
        return holder.format("Cloud.AgentsProperties");
    }

    /**
     * Key {@code Cloud.AgentsProperties}: {@code Agents Properties}.
     * 
     * @return
     *     {@code Agents Properties}
     */
    public static Localizable _Cloud_AgentsProperties() {
        return new Localizable(holder, "Cloud.AgentsProperties");
    }

    /**
     * Key {@code Cloud.DisplayName}: {@code Mac}.
     * 
     * @return
     *     {@code Mac}
     */
    public static String Cloud_DisplayName() {
        return holder.format("Cloud.DisplayName");
    }

    /**
     * Key {@code Cloud.DisplayName}: {@code Mac}.
     * 
     * @return
     *     {@code Mac}
     */
    public static Localizable _Cloud_DisplayName() {
        return new Localizable(holder, "Cloud.DisplayName");
    }

    /**
     * Key {@code EnvVar.Title}: {@code Environment variables}.
     * 
     * @return
     *     {@code Environment variables}
     */
    public static String EnvVar_Title() {
        return holder.format("EnvVar.Title");
    }

    /**
     * Key {@code EnvVar.Title}: {@code Environment variables}.
     * 
     * @return
     *     {@code Environment variables}
     */
    public static Localizable _EnvVar_Title() {
        return new Localizable(holder, "EnvVar.Title");
    }

    /**
     * Key {@code Keychain.DisplayName}: {@code Keychain file}.
     * 
     * @return
     *     {@code Keychain file}
     */
    public static String Keychain_DisplayName() {
        return holder.format("Keychain.DisplayName");
    }

    /**
     * Key {@code Keychain.DisplayName}: {@code Keychain file}.
     * 
     * @return
     *     {@code Keychain file}
     */
    public static Localizable _Keychain_DisplayName() {
        return new Localizable(holder, "Keychain.DisplayName");
    }

    /**
     * Key {@code MacHostKeyVerifier.UnexpectedKeyAlgorithm}: {@code

     * Unexpected key algorithm: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unexpected key algorithm: {0}}
     */
    public static String MacHostKeyVerifier_UnexpectedKeyAlgorithm(Object arg0) {
        return holder.format("MacHostKeyVerifier.UnexpectedKeyAlgorithm", arg0);
    }

    /**
     * Key {@code MacHostKeyVerifier.UnexpectedKeyAlgorithm}: {@code

     * Unexpected key algorithm: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unexpected key algorithm: {0}}
     */
    public static Localizable _MacHostKeyVerifier_UnexpectedKeyAlgorithm(Object arg0) {
        return new Localizable(holder, "MacHostKeyVerifier.UnexpectedKeyAlgorithm", arg0);
    }

    /**
     * Key {@code Host.ConnectionSucceeded}: {@code Connected as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connected as {0}}
     */
    public static String Host_ConnectionSucceeded(Object arg0) {
        return holder.format("Host.ConnectionSucceeded", arg0);
    }

    /**
     * Key {@code Host.ConnectionSucceeded}: {@code Connected as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connected as {0}}
     */
    public static Localizable _Host_ConnectionSucceeded(Object arg0) {
        return new Localizable(holder, "Host.ConnectionSucceeded", arg0);
    }

    /**
     * Key {@code Cloud.PrefixStartSlaveCmd}: {@code Prefix Start Agent

     * Command}.
     * 
     * @return
     *     {@code Prefix Start Agent Command}
     */
    public static String Cloud_PrefixStartSlaveCmd() {
        return holder.format("Cloud.PrefixStartSlaveCmd");
    }

    /**
     * Key {@code Cloud.PrefixStartSlaveCmd}: {@code Prefix Start Agent

     * Command}.
     * 
     * @return
     *     {@code Prefix Start Agent Command}
     */
    public static Localizable _Cloud_PrefixStartSlaveCmd() {
        return new Localizable(holder, "Cloud.PrefixStartSlaveCmd");
    }

    /**
     * Key {@code EnvVar.Key}: {@code Key}.
     * 
     * @return
     *     {@code Key}
     */
    public static String EnvVar_Key() {
        return holder.format("EnvVar.Key");
    }

    /**
     * Key {@code EnvVar.Key}: {@code Key}.
     * 
     * @return
     *     {@code Key}
     */
    public static Localizable _EnvVar_Key() {
        return new Localizable(holder, "EnvVar.Key");
    }

    /**
     * Key {@code Keychain.Title}: {@code Upload a keychain file}.
     * 
     * @return
     *     {@code Upload a keychain file}
     */
    public static String Keychain_Title() {
        return holder.format("Keychain.Title");
    }

    /**
     * Key {@code Keychain.Title}: {@code Upload a keychain file}.
     * 
     * @return
     *     {@code Upload a keychain file}
     */
    public static Localizable _Keychain_Title() {
        return new Localizable(holder, "Keychain.Title");
    }

    /**
     * Key {@code Host.Port}: {@code Port}.
     * 
     * @return
     *     {@code Port}
     */
    public static String Host_Port() {
        return holder.format("Host.Port");
    }

    /**
     * Key {@code Host.Port}: {@code Port}.
     * 
     * @return
     *     {@code Port}
     */
    public static Localizable _Host_Port() {
        return new Localizable(holder, "Host.Port");
    }

    /**
     * Key {@code EnvVar.Value}: {@code Value}.
     * 
     * @return
     *     {@code Value}
     */
    public static String EnvVar_Value() {
        return holder.format("EnvVar.Value");
    }

    /**
     * Key {@code EnvVar.Value}: {@code Value}.
     * 
     * @return
     *     {@code Value}
     */
    public static Localizable _EnvVar_Value() {
        return new Localizable(holder, "EnvVar.Value");
    }

    /**
     * Key {@code Host.Credentials}: {@code Credentials}.
     * 
     * @return
     *     {@code Credentials}
     */
    public static String Host_Credentials() {
        return holder.format("Host.Credentials");
    }

    /**
     * Key {@code Host.Credentials}: {@code Credentials}.
     * 
     * @return
     *     {@code Credentials}
     */
    public static Localizable _Host_Credentials() {
        return new Localizable(holder, "Host.Credentials");
    }

    /**
     * Key {@code EnvVar.Delete}: {@code Delete environment variable}.
     * 
     * @return
     *     {@code Delete environment variable}
     */
    public static String EnvVar_Delete() {
        return holder.format("EnvVar.Delete");
    }

    /**
     * Key {@code EnvVar.Delete}: {@code Delete environment variable}.
     * 
     * @return
     *     {@code Delete environment variable}
     */
    public static Localizable _EnvVar_Delete() {
        return new Localizable(holder, "EnvVar.Delete");
    }

    /**
     * Key {@code MacSlave.Executors}: {@code # of executors}.
     * 
     * @return
     *     {@code # of executors}
     */
    public static String MacSlave_Executors() {
        return holder.format("MacSlave.Executors");
    }

    /**
     * Key {@code MacSlave.Executors}: {@code # of executors}.
     * 
     * @return
     *     {@code # of executors}
     */
    public static Localizable _MacSlave_Executors() {
        return new Localizable(holder, "MacSlave.Executors");
    }

    /**
     * Key {@code Host.Title}: {@code Mac Hosts}.
     * 
     * @return
     *     {@code Mac Hosts}
     */
    public static String Host_Title() {
        return holder.format("Host.Title");
    }

    /**
     * Key {@code Host.Title}: {@code Mac Hosts}.
     * 
     * @return
     *     {@code Mac Hosts}
     */
    public static Localizable _Host_Title() {
        return new Localizable(holder, "Host.Title");
    }

    /**
     * Key {@code MacHostKeyVerifier.TwoPartKey}: {@code Key should be 2

     * parts: algorithm and Base 64 encoded key value.}.
     * 
     * @return
     *     {@code Key should be 2 parts: algorithm and Base 64 encoded key

     *     value.}
     */
    public static String MacHostKeyVerifier_TwoPartKey() {
        return holder.format("MacHostKeyVerifier.TwoPartKey");
    }

    /**
     * Key {@code MacHostKeyVerifier.TwoPartKey}: {@code Key should be 2

     * parts: algorithm and Base 64 encoded key value.}.
     * 
     * @return
     *     {@code Key should be 2 parts: algorithm and Base 64 encoded key

     *     value.}
     */
    public static Localizable _MacHostKeyVerifier_TwoPartKey() {
        return new Localizable(holder, "MacHostKeyVerifier.TwoPartKey");
    }

    /**
     * Key {@code Host.DisplayName}: {@code Mac Host}.
     * 
     * @return
     *     {@code Mac Host}
     */
    public static String Host_DisplayName() {
        return holder.format("Host.DisplayName");
    }

    /**
     * Key {@code Host.DisplayName}: {@code Mac Host}.
     * 
     * @return
     *     {@code Mac Host}
     */
    public static Localizable _Host_DisplayName() {
        return new Localizable(holder, "Host.DisplayName");
    }

    /**
     * Key {@code Cloud.JenkinsUrl}: {@code Jenkins URL}.
     * 
     * @return
     *     {@code Jenkins URL}
     */
    public static String Cloud_JenkinsUrl() {
        return holder.format("Cloud.JenkinsUrl");
    }

    /**
     * Key {@code Cloud.JenkinsUrl}: {@code Jenkins URL}.
     * 
     * @return
     *     {@code Jenkins URL}
     */
    public static Localizable _Cloud_JenkinsUrl() {
        return new Localizable(holder, "Cloud.JenkinsUrl");
    }

    /**
     * Key {@code Host.ReadTimeout}: {@code Read timeout}.
     * 
     * @return
     *     {@code Read timeout}
     */
    public static String Host_ReadTimeout() {
        return holder.format("Host.ReadTimeout");
    }

    /**
     * Key {@code Host.ReadTimeout}: {@code Read timeout}.
     * 
     * @return
     *     {@code Read timeout}
     */
    public static Localizable _Host_ReadTimeout() {
        return new Localizable(holder, "Host.ReadTimeout");
    }

    /**
     * Key {@code MacHostKeyVerifier.UnknownKeyAlgorithm}: {@code Key

     * algorithm should be one of ssh-rsa or ssh-dss.}.
     * 
     * @return
     *     {@code Key algorithm should be one of ssh-rsa or ssh-dss.}
     */
    public static String MacHostKeyVerifier_UnknownKeyAlgorithm() {
        return holder.format("MacHostKeyVerifier.UnknownKeyAlgorithm");
    }

    /**
     * Key {@code MacHostKeyVerifier.UnknownKeyAlgorithm}: {@code Key

     * algorithm should be one of ssh-rsa or ssh-dss.}.
     * 
     * @return
     *     {@code Key algorithm should be one of ssh-rsa or ssh-dss.}
     */
    public static Localizable _MacHostKeyVerifier_UnknownKeyAlgorithm() {
        return new Localizable(holder, "MacHostKeyVerifier.UnknownKeyAlgorithm");
    }

    /**
     * Key {@code MacSlave.RemoteFSRoot}: {@code Remote FS root}.
     * 
     * @return
     *     {@code Remote FS root}
     */
    public static String MacSlave_RemoteFSRoot() {
        return holder.format("MacSlave.RemoteFSRoot");
    }

    /**
     * Key {@code MacSlave.RemoteFSRoot}: {@code Remote FS root}.
     * 
     * @return
     *     {@code Remote FS root}
     */
    public static Localizable _MacSlave_RemoteFSRoot() {
        return new Localizable(holder, "MacSlave.RemoteFSRoot");
    }

    /**
     * Key {@code Host.Delete}: {@code Delete Mac Host}.
     * 
     * @return
     *     {@code Delete Mac Host}
     */
    public static String Host_Delete() {
        return holder.format("Host.Delete");
    }

    /**
     * Key {@code Host.Delete}: {@code Delete Mac Host}.
     * 
     * @return
     *     {@code Delete Mac Host}
     */
    public static Localizable _Host_Delete() {
        return new Localizable(holder, "Host.Delete");
    }

    /**
     * Key {@code Host.MaxTries}: {@code Max connection retries}.
     * 
     * @return
     *     {@code Max connection retries}
     */
    public static String Host_MaxTries() {
        return holder.format("Host.MaxTries");
    }

    /**
     * Key {@code Host.MaxTries}: {@code Max connection retries}.
     * 
     * @return
     *     {@code Max connection retries}
     */
    public static Localizable _Host_MaxTries() {
        return new Localizable(holder, "Host.MaxTries");
    }

    /**
     * Key {@code Cloud.Labels}: {@code Labels}.
     * 
     * @return
     *     {@code Labels}
     */
    public static String Cloud_Labels() {
        return holder.format("Cloud.Labels");
    }

    /**
     * Key {@code Cloud.Labels}: {@code Labels}.
     * 
     * @return
     *     {@code Labels}
     */
    public static Localizable _Cloud_Labels() {
        return new Localizable(holder, "Cloud.Labels");
    }

    /**
     * Key {@code Cloud.Details}: {@code Cloud details}.
     * 
     * @return
     *     {@code Cloud details}
     */
    public static String Cloud_Details() {
        return holder.format("Cloud.Details");
    }

    /**
     * Key {@code Cloud.Details}: {@code Cloud details}.
     * 
     * @return
     *     {@code Cloud details}
     */
    public static Localizable _Cloud_Details() {
        return new Localizable(holder, "Cloud.Details");
    }

    /**
     * Key {@code Host.Host}: {@code Host}.
     * 
     * @return
     *     {@code Host}
     */
    public static String Host_Host() {
        return holder.format("Host.Host");
    }

    /**
     * Key {@code Host.Host}: {@code Host}.
     * 
     * @return
     *     {@code Host}
     */
    public static Localizable _Host_Host() {
        return new Localizable(holder, "Host.Host");
    }

    /**
     * Key {@code Cloud.JavaPath}: {@code JavaPath}.
     * 
     * @return
     *     {@code JavaPath}
     */
    public static String Cloud_JavaPath() {
        return holder.format("Cloud.JavaPath");
    }

    /**
     * Key {@code Cloud.JavaPath}: {@code JavaPath}.
     * 
     * @return
     *     {@code JavaPath}
     */
    public static Localizable _Cloud_JavaPath() {
        return new Localizable(holder, "Cloud.JavaPath");
    }

    /**
     * Key {@code MacHostKeyVerifier.KeyTrusted}: {@code SSH host key matched

     * the key required for this connection. Connection will be allowed for

     * the host {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SSH host key matched the key required for this connection.

     *     Connection will be allowed for the host {0}.}
     */
    public static String MacHostKeyVerifier_KeyTrusted(Object arg0) {
        return holder.format("MacHostKeyVerifier.KeyTrusted", arg0);
    }

    /**
     * Key {@code MacHostKeyVerifier.KeyTrusted}: {@code SSH host key matched

     * the key required for this connection. Connection will be allowed for

     * the host {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SSH host key matched the key required for this connection.

     *     Connection will be allowed for the host {0}.}
     */
    public static Localizable _MacHostKeyVerifier_KeyTrusted(Object arg0) {
        return new Localizable(holder, "MacHostKeyVerifier.KeyTrusted", arg0);
    }

    /**
     * Key {@code Host.ConnectionFailed}: {@code Connection failed : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed : {0}}
     */
    public static String Host_ConnectionFailed(Object arg0) {
        return holder.format("Host.ConnectionFailed", arg0);
    }

    /**
     * Key {@code Host.ConnectionFailed}: {@code Connection failed : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed : {0}}
     */
    public static Localizable _Host_ConnectionFailed(Object arg0) {
        return new Localizable(holder, "Host.ConnectionFailed", arg0);
    }

    /**
     * Key {@code MacHostKeyVerifier.HostKey}: {@code Host Key}.
     * 
     * @return
     *     {@code Host Key}
     */
    public static String MacHostKeyVerifier_HostKey() {
        return holder.format("MacHostKeyVerifier.HostKey");
    }

    /**
     * Key {@code MacHostKeyVerifier.HostKey}: {@code Host Key}.
     * 
     * @return
     *     {@code Host Key}
     */
    public static Localizable _MacHostKeyVerifier_HostKey() {
        return new Localizable(holder, "MacHostKeyVerifier.HostKey");
    }

    /**
     * Key {@code Cloud.JvmOptions}: {@code Options de la JVM}.
     * 
     * @return
     *     {@code Options de la JVM}
     */
    public static String Cloud_JvmOptions() {
        return holder.format("Cloud.JvmOptions");
    }

    /**
     * Key {@code Cloud.JvmOptions}: {@code Options de la JVM}.
     * 
     * @return
     *     {@code Options de la JVM}
     */
    public static Localizable _Cloud_JvmOptions() {
        return new Localizable(holder, "Cloud.JvmOptions");
    }

    /**
     * Key {@code Host.Details}: {@code Host details}.
     * 
     * @return
     *     {@code Host details}
     */
    public static String Host_Details() {
        return holder.format("Host.Details");
    }

    /**
     * Key {@code Host.Details}: {@code Host details}.
     * 
     * @return
     *     {@code Host details}
     */
    public static Localizable _Host_Details() {
        return new Localizable(holder, "Host.Details");
    }

    /**
     * Key {@code MacHostKeyVerifier.Base64EncodedKeyValueRequired}: {@code

     * The value part of the key should be a Base64 encoded value.}.
     * 
     * @return
     *     {@code The value part of the key should be a Base64 encoded value.}
     */
    public static String MacHostKeyVerifier_Base64EncodedKeyValueRequired() {
        return holder.format("MacHostKeyVerifier.Base64EncodedKeyValueRequired");
    }

    /**
     * Key {@code MacHostKeyVerifier.Base64EncodedKeyValueRequired}: {@code

     * The value part of the key should be a Base64 encoded value.}.
     * 
     * @return
     *     {@code The value part of the key should be a Base64 encoded value.}
     */
    public static Localizable _MacHostKeyVerifier_Base64EncodedKeyValueRequired() {
        return new Localizable(holder, "MacHostKeyVerifier.Base64EncodedKeyValueRequired");
    }

    /**
     * Key {@code Host.KexTimeout}: {@code Key exchange timeout}.
     * 
     * @return
     *     {@code Key exchange timeout}
     */
    public static String Host_KexTimeout() {
        return holder.format("Host.KexTimeout");
    }

    /**
     * Key {@code Host.KexTimeout}: {@code Key exchange timeout}.
     * 
     * @return
     *     {@code Key exchange timeout}
     */
    public static Localizable _Host_KexTimeout() {
        return new Localizable(holder, "Host.KexTimeout");
    }

    /**
     * Key {@code Cloud.IdleMinutes}: {@code Idle minutes}.
     * 
     * @return
     *     {@code Idle minutes}
     */
    public static String Cloud_IdleMinutes() {
        return holder.format("Cloud.IdleMinutes");
    }

    /**
     * Key {@code Cloud.IdleMinutes}: {@code Idle minutes}.
     * 
     * @return
     *     {@code Idle minutes}
     */
    public static Localizable _Cloud_IdleMinutes() {
        return new Localizable(holder, "Cloud.IdleMinutes");
    }

    /**
     * Key {@code EnvVar.DisplayName}: {@code Environment variable}.
     * 
     * @return
     *     {@code Environment variable}
     */
    public static String EnvVar_DisplayName() {
        return holder.format("EnvVar.DisplayName");
    }

    /**
     * Key {@code EnvVar.DisplayName}: {@code Environment variable}.
     * 
     * @return
     *     {@code Environment variable}
     */
    public static Localizable _EnvVar_DisplayName() {
        return new Localizable(holder, "EnvVar.DisplayName");
    }

}
