/*
 * Decompiled with CFR 0.152.
 */
package de.jamba.hudson.plugin.wsclean;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class TaskUtils {
    @Restricted(value={NoExternalUse.class})
    static <T> T runWithTimeout(ExecutorService threadpool, long timeoutInMs, Callable<T> task) throws InterruptedException, TimeoutException {
        Future<T> futureResult = threadpool.submit(task);
        try {
            T t = futureResult.get(timeoutInMs, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new RuntimeException(cause);
        }
        finally {
            futureResult.cancel(true);
        }
    }

    @Restricted(value={NoExternalUse.class})
    static <T> T runWithoutTimeout(Callable<T> task) throws InterruptedException {
        try {
            return task.call();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    static void waitUntilAllAreDone(Iterable<Future<?>> asyncTasks) throws InterruptedException {
        long millisecondsToWaitLongerEachTime = 50L;
        long maxMillisecondsToWaitBetweenPolls = 1000L;
        long millisecondsToWaitFirstTime = 50L;
        long millisecondsToWaitThisTime = 50L;
        Future<?> incompleteTask = TaskUtils.getFirstIncompleteTask(asyncTasks);
        while (incompleteTask != null) {
            try {
                incompleteTask.get(millisecondsToWaitThisTime, TimeUnit.MILLISECONDS);
                millisecondsToWaitThisTime = 50L;
            }
            catch (ExecutionException e) {
                millisecondsToWaitThisTime = 50L;
            }
            catch (TimeoutException e) {
                millisecondsToWaitThisTime = Math.min(1000L, millisecondsToWaitThisTime + 50L);
            }
            catch (InterruptedException e) {
                throw e;
            }
            incompleteTask = TaskUtils.getFirstIncompleteTask(asyncTasks);
        }
    }

    private static <T extends Future<?>> T getFirstIncompleteTask(Iterable<T> asyncTasks) {
        for (Future t : asyncTasks) {
            if (t.isDone()) continue;
            return (T)t;
        }
        return null;
    }
}

