/*
 * Decompiled with CFR 0.152.
 */
package de.jamba.hudson.plugin.wsclean;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import de.jamba.hudson.plugin.wsclean.CommonConfig;
import de.jamba.hudson.plugin.wsclean.DisablePrePostCleanNodeProperty;
import de.jamba.hudson.plugin.wsclean.Messages;
import de.jamba.hudson.plugin.wsclean.TaskUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TopLevelItem;
import hudson.remoting.RequestAbortedException;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrePostClean
extends BuildWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrePostClean.class);
    private boolean before;
    @Deprecated
    private transient Boolean behind;

    public PrePostClean() {
    }

    @DataBoundConstructor
    public PrePostClean(boolean before) {
        this();
        this.setBefore(before);
    }

    public boolean isBefore() {
        return this.before;
    }

    @DataBoundSetter
    public void setBefore(boolean before) {
        this.before = before;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        boolean runAtStart = this.isBefore();
        final boolean runAtEnd = !runAtStart;
        CommonConfig commonConfig = CommonConfig.get();
        final boolean skipRoaming = commonConfig.getSkipRoaming();
        final CommonConfig.NodeSelection nodeSelectionMethod = commonConfig.getNodeSelection();
        final Pattern[] nodeNamesToSkip = commonConfig.getNodeNamesToSkipPatterns();
        final boolean parallel = commonConfig.getParallel();
        final long timeoutInMs = commonConfig.getTimeoutInMilliseconds();
        final Jenkins jenkins = Jenkins.getInstance();
        final ExecutorService parallelExecutor = Computer.threadPoolForRemoting;
        LOGGER.info("setUp({},,): runAtStart={}, runAtEnd={}, nodeSelectionMethod={}, skipRoaming={}, nodeNamesToSkip={}, parallel={}, timeoutInMs={}", new Object[]{build, runAtStart, runAtEnd, nodeSelectionMethod.name(), skipRoaming, Arrays.asList(nodeNamesToSkip), parallel, timeoutInMs});
        if (runAtStart) {
            this.executeOnSlaves("Pre", jenkins, parallelExecutor, build, listener, nodeSelectionMethod, skipRoaming, nodeNamesToSkip, parallel, timeoutInMs);
        }
        class TearDownImpl
        extends BuildWrapper.Environment {
            TearDownImpl() {
                super((BuildWrapper)PrePostClean.this);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (runAtEnd) {
                    PrePostClean.this.executeOnSlaves("Post", jenkins, parallelExecutor, build, listener, nodeSelectionMethod, skipRoaming, nodeNamesToSkip, parallel, timeoutInMs);
                }
                return super.tearDown(build, listener);
            }
        }
        return new TearDownImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    void executeOnSlaves(String preOrPost, Jenkins jenkins, ExecutorService executor, AbstractBuild<?, ?> build, BuildListener listener, CommonConfig.NodeSelection nodeSelection, boolean skipRoaming, Pattern[] nodeNamesToSkip, boolean parallel, long timeoutInMs) throws InterruptedException {
        listener.getLogger().println(preOrPost + "-build clean running...");
        String result = "abandoned";
        try {
            boolean success = this.cleanUp(jenkins, executor, build, listener, nodeSelection, skipRoaming, nodeNamesToSkip, parallel, timeoutInMs);
            result = success ? "completed" : "failed";
        }
        finally {
            listener.getLogger().println(preOrPost + "-build clean " + result + ".");
        }
    }

    private boolean cleanUp(final Jenkins jenkins, final ExecutorService executor, final AbstractBuild<?, ?> build, final BuildListener listener, CommonConfig.NodeSelection nodeSelection, boolean skipRoaming, Pattern[] nodeNameRegexsToSkip, final boolean parallel, long timeoutInMs) throws InterruptedException {
        LOGGER.debug("cleanUp({}) started", build);
        final Multimap<String, String> workspacesToBeRemoved = this.calculateWssForRemoval(jenkins, build, listener, nodeSelection, skipRoaming);
        LOGGER.debug("cleanUp({}): calculateWssForRemoval(,,,{},{})={}", new Object[]{build, nodeSelection, skipRoaming, workspacesToBeRemoved});
        List<String> nodesToSkipDueToTheirName = PrePostClean.getMatching(workspacesToBeRemoved.keySet(), nodeNameRegexsToSkip);
        LOGGER.debug("cleanUp({}): nodesToSkipDueToTheirName={}", build, nodesToSkipDueToTheirName);
        workspacesToBeRemoved.keySet().removeAll(nodesToSkipDueToTheirName);
        List<String> nodesToSkipDueToNodeProperty = PrePostClean.getNodesWithDisableProperty(workspacesToBeRemoved.keySet(), jenkins);
        LOGGER.debug("cleanUp({}): nodesToSkipDueToNodeProperty={}", build, nodesToSkipDueToNodeProperty);
        workspacesToBeRemoved.keySet().removeAll(nodesToSkipDueToNodeProperty);
        class CleanOldWorkspaces
        implements Callable<Void> {
            CleanOldWorkspaces() {
            }

            @Override
            public Void call() throws InterruptedException {
                if (parallel) {
                    LOGGER.debug("cleanUp({}): deleteWssInParallel...", (Object)build);
                    PrePostClean.this.deleteWssInParallel(build, jenkins, executor, (Multimap<String, String>)workspacesToBeRemoved, listener);
                } else {
                    LOGGER.debug("cleanUp({}): deleteWssInSeries...", (Object)build);
                    PrePostClean.this.deleteWssInSeries(build, jenkins, (Multimap<String, String>)workspacesToBeRemoved, listener);
                }
                LOGGER.debug("cleanUp({}): deleted.", (Object)build);
                return null;
            }
        }
        CleanOldWorkspaces deletionTask = new CleanOldWorkspaces();
        boolean success = false;
        if (timeoutInMs > 0L) {
            LOGGER.debug("cleanUp({}): using timeout of {}.", build, (Object)timeoutInMs);
            try {
                TaskUtils.runWithTimeout(executor, timeoutInMs, deletionTask);
                success = true;
            }
            catch (TimeoutException e) {
                listener.getLogger().println("Clean did not complete within " + timeoutInMs + " milliseconds.");
            }
        } else {
            TaskUtils.runWithoutTimeout(deletionTask);
            success = true;
        }
        LOGGER.debug("cleanUp({}): completed.", build);
        return success;
    }

    private Multimap<String, String> calculateWssForRemoval(Jenkins jenkins, AbstractBuild<?, ?> build, BuildListener listener, CommonConfig.NodeSelection nodeSelection, boolean skipRoaming) {
        TreeSet nodeNamesOfDeadNodes;
        TreeMultimap currentWssFromHistory;
        TreeMultimap oldWssFromHistory;
        TreeMultimap wssForRemovalFromLabels;
        if (nodeSelection.getUseLabels()) {
            wssForRemovalFromLabels = TreeMultimap.create();
            this.findPossibleWssFromJobLabel((Multimap<String, String>)wssForRemovalFromLabels, jenkins, build, listener, skipRoaming);
        } else {
            wssForRemovalFromLabels = null;
        }
        if (nodeSelection.getUseHistory() || build.getProject().isConcurrentBuild()) {
            oldWssFromHistory = TreeMultimap.create();
            currentWssFromHistory = TreeMultimap.create();
            nodeNamesOfDeadNodes = Sets.newTreeSet();
            this.findWssFromBuildHistory((Multimap<String, String>)currentWssFromHistory, (Multimap<String, String>)oldWssFromHistory, nodeNamesOfDeadNodes, build);
        } else {
            oldWssFromHistory = null;
            currentWssFromHistory = null;
            nodeNamesOfDeadNodes = null;
        }
        TreeMultimap workspacesToBeRemoved = TreeMultimap.create();
        if (nodeSelection.getUseLabels()) {
            workspacesToBeRemoved.putAll((Multimap)wssForRemovalFromLabels);
        }
        if (nodeSelection.getUseHistory()) {
            workspacesToBeRemoved.putAll((Multimap)oldWssFromHistory);
            for (String offlineNode : nodeNamesOfDeadNodes) {
                workspacesToBeRemoved.removeAll((Object)offlineNode);
            }
        }
        if (currentWssFromHistory != null) {
            for (Map.Entry workspaceCurrentlyInUse : currentWssFromHistory.entries()) {
                workspacesToBeRemoved.remove(workspaceCurrentlyInUse.getKey(), workspaceCurrentlyInUse.getValue());
            }
        }
        return workspacesToBeRemoved;
    }

    private void findPossibleWssFromJobLabel(Multimap<String, String> result, Jenkins jenkins, AbstractBuild<?, ?> build, BuildListener listener, boolean skipRoaming) {
        String runNode = build.getBuiltOnStr();
        AbstractProject project = build.getProject();
        Label assignedLabel = project.getAssignedLabel();
        if (assignedLabel == null && skipRoaming) {
            listener.getLogger().println("Skipping roaming project.");
            return;
        }
        Set<Node> nodesForLabel = assignedLabel != null ? assignedLabel.getNodes() : PrePostClean.getAllNonexclusiveNodes(jenkins);
        LOGGER.debug("calculatePotentialWssFromJobLabel(,{},{}): assignedLabel={} evaluates to nodesForLabel={}", new Object[]{build, skipRoaming, assignedLabel == null ? null : assignedLabel.getExpression(), nodesForLabel});
        if (nodesForLabel != null) {
            for (Node node : nodesForLabel) {
                String nodeName = node.getNodeName();
                if (!runNode.equals(nodeName)) {
                    String normalizedName = PrePostClean.toNormalizedNodeName(nodeName);
                    String folderOnNode = this.getWorkspaceOn(project, listener, node, normalizedName);
                    LOGGER.debug("calculatePotentialWssFromJobLabel(,{},{}): Node={}, folder={}", new Object[]{build, skipRoaming, nodeName, folderOnNode});
                    if (folderOnNode == null) continue;
                    result.put((Object)nodeName, (Object)folderOnNode);
                    continue;
                }
                LOGGER.debug("calculatePotentialWssFromJobLabel(,{},{}): Node={} is current node, so excluding", new Object[]{build, skipRoaming, nodeName});
            }
        }
    }

    private void findWssFromBuildHistory(Multimap<String, String> wssCurrentlyInUse, Multimap<String, String> wssPreviouslyUsed, Set<String> nodeNamesOfDeadNodes, AbstractBuild<?, ?> build) {
        AbstractProject project = build.getProject();
        RunList builds = project.getBuilds();
        for (Object historyEntry : builds) {
            if (!(historyEntry instanceof AbstractBuild)) {
                LOGGER.debug("calculateUnusedWssFromBuildHistory({}): {} is not AbstractBuild", build, historyEntry);
                continue;
            }
            AbstractBuild historicalBuild = (AbstractBuild)historyEntry;
            if (historicalBuild.hasntStartedYet()) {
                LOGGER.debug("calculateUnusedWssFromBuildHistory({}): {} has not started", build, (Object)historicalBuild);
                continue;
            }
            String nodeItRanOn = Util.fixNull((String)historicalBuild.getBuiltOnStr());
            Node node = historicalBuild.getBuiltOn();
            if (node == null) {
                LOGGER.debug("calculateUnusedWssFromBuildHistory({}): {} ran on node {} which is deleted.", new Object[]{build, historicalBuild, nodeItRanOn});
                nodeNamesOfDeadNodes.add(nodeItRanOn);
                continue;
            }
            FilePath wsOrNull = historicalBuild.getWorkspace();
            if (wsOrNull == null) {
                LOGGER.debug("calculateUnusedWssFromBuildHistory({}): {} ran on node {} which is offline so ws unavailable.", new Object[]{build, historicalBuild, nodeItRanOn});
                nodeNamesOfDeadNodes.add(nodeItRanOn);
                continue;
            }
            boolean buildIsNotFinished = historicalBuild.isBuilding() || historicalBuild.getExecutor() != null;
            String folderOnNode = wsOrNull.getRemote();
            LOGGER.debug("calculateUnusedWssFromBuildHistory({}): Unfinished={} {} ran on node {} in folder {}.", new Object[]{build, buildIsNotFinished, historicalBuild, nodeItRanOn, folderOnNode});
            if (buildIsNotFinished) {
                wssCurrentlyInUse.put((Object)nodeItRanOn, (Object)folderOnNode);
                continue;
            }
            wssPreviouslyUsed.put((Object)nodeItRanOn, (Object)folderOnNode);
        }
    }

    @Restricted(value={NoExternalUse.class})
    void deleteWssInSeries(AbstractBuild<?, ?> build, Jenkins nodeContainer, Multimap<String, String> workspacesToBeRemoved, BuildListener listener) throws InterruptedException {
        for (Map.Entry e : workspacesToBeRemoved.asMap().entrySet()) {
            Iterable foldersToDelete = (Iterable)e.getValue();
            String nodeName = (String)e.getKey();
            String normalizedNodeName = PrePostClean.toNormalizedNodeName(nodeName);
            Node node = PrePostClean.getNode(nodeContainer, nodeName);
            if (node == null) {
                LOGGER.debug("deleteWssInSeries({}): node==null for normalizedNodeName={}, foldersToDelete={}", new Object[]{build, normalizedNodeName, foldersToDelete});
                continue;
            }
            for (String folderToDelete : foldersToDelete) {
                FilePath fp = node.createPath(folderToDelete);
                if (fp == null) {
                    LOGGER.debug("deleteWssInSeries({}): fp==null for normalizedNodeName={}, folderToDelete={}", new Object[]{build, normalizedNodeName, folderToDelete});
                    continue;
                }
                listener.getLogger().println("Cleaning " + normalizedNodeName + " folder " + fp);
                LOGGER.debug("deleteWssInSeries({}): deleting normalizedNodeName={}, folderToDelete={}", new Object[]{build, normalizedNodeName, folderToDelete});
                this.deleteWorkspaceOn(build, listener, normalizedNodeName, fp);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    void deleteWssInParallel(final AbstractBuild<?, ?> build, Jenkins nodeContainer, ExecutorService parallelExecutor, Multimap<String, String> workspacesToBeRemoved, final BuildListener listener) throws InterruptedException {
        ArrayList deletionTaskResults = Lists.newArrayList();
        for (Map.Entry e : workspacesToBeRemoved.asMap().entrySet()) {
            final Iterable foldersToDelete = (Iterable)e.getValue();
            String nodeName = (String)e.getKey();
            final String normalizedNodeName = PrePostClean.toNormalizedNodeName(nodeName);
            final Node node = PrePostClean.getNode(nodeContainer, nodeName);
            if (node == null) {
                LOGGER.debug("deleteWssInParallel({}): node==null for normalizedNodeName={}, foldersToDelete={}", new Object[]{build, normalizedNodeName, foldersToDelete});
                continue;
            }
            class CleanFoldersOnOneNode
            implements Callable<Void> {
                CleanFoldersOnOneNode() {
                }

                @Override
                public Void call() throws Exception {
                    try {
                        for (String folderToDelete : foldersToDelete) {
                            FilePath fp = node.createPath(folderToDelete);
                            if (fp == null) continue;
                            listener.getLogger().println("Cleaning " + normalizedNodeName + " folder " + fp);
                            PrePostClean.this.deleteWorkspaceOn(build, listener, normalizedNodeName, fp);
                        }
                    }
                    catch (InterruptedException e) {
                        listener.getLogger().println("Cleaning on " + normalizedNodeName + " was interrupted.");
                    }
                    return null;
                }
            }
            CleanFoldersOnOneNode task = new CleanFoldersOnOneNode();
            LOGGER.debug("deleteWssInParallel({}): submitting task to delete normalizedNodeName={}, foldersToDelete={}", new Object[]{build, normalizedNodeName, foldersToDelete});
            Future<Void> futureResult = parallelExecutor.submit(task);
            deletionTaskResults.add(futureResult);
        }
        LOGGER.debug("deleteWssInParallel({}): waiting for {} deletions to complete", build, (Object)deletionTaskResults.size());
        try {
            TaskUtils.waitUntilAllAreDone(deletionTaskResults);
            LOGGER.debug("deleteWssInParallel({}): wait complete", build);
        }
        catch (InterruptedException ex) {
            for (Future t : deletionTaskResults) {
                t.cancel(true);
            }
            throw ex;
        }
    }

    private String getWorkspaceOn(AbstractProject<?, ?> project, BuildListener listener, Node node, String nodeName) {
        if (project instanceof TopLevelItem) {
            FilePath fp = node.getWorkspaceFor((TopLevelItem)project);
            if (fp != null) {
                return fp.getRemote();
            }
            listener.getLogger().println("No workspace found on " + nodeName + ". Node is maybe offline.");
        } else {
            listener.getLogger().println("Project is not TopLevelItem! Cannot determine other workspaces!");
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    void deleteWorkspaceOn(AbstractBuild<?, ?> build, BuildListener listener, String nodeName, FilePath fp) throws InterruptedException {
        try {
            LOGGER.trace("deleteWorkspaceOn({}): Deleting {} on node {}", new Object[]{build, fp.getRemote(), nodeName});
            fp.deleteContents();
        }
        catch (RequestAbortedException | IOException e) {
            listener.getLogger().println("Can't delete " + fp.getRemote() + " on node " + nodeName + "\n" + e.getMessage());
            listener.getLogger().print(e);
        }
    }

    private static String toNormalizedNodeName(String nodeName) {
        String normalizedNodeName = nodeName == null || "".equals(nodeName) ? "master" : nodeName;
        return normalizedNodeName;
    }

    private static Node getNode(Jenkins nodeContainer, String nodeName) {
        if (nodeName.isEmpty()) {
            return nodeContainer;
        }
        return nodeContainer.getNode(nodeName);
    }

    private static List<String> getMatching(Iterable<String> input, Pattern[] patternsToMatch) {
        ArrayList result = Lists.newArrayList();
        block0: for (String s : input) {
            for (Pattern p : patternsToMatch) {
                if (!p.matcher(s).matches()) continue;
                result.add(s);
                continue block0;
            }
        }
        return result;
    }

    private static Set<Node> getAllNonexclusiveNodes(Jenkins jenkins) {
        HashSet result = Sets.newHashSet();
        for (Node n : jenkins.getNodes()) {
            if (!Node.Mode.NORMAL.equals((Object)n.getMode())) continue;
            result.add(n);
        }
        if (Node.Mode.NORMAL.equals((Object)jenkins.getMode())) {
            result.add(jenkins);
        }
        return result;
    }

    private static List<String> getNodesWithDisableProperty(Set<String> nodesToConsider, Jenkins jenkins) {
        ArrayList result = Lists.newArrayList();
        for (Node n : jenkins.getNodes()) {
            String nodeName = n.getNodeName();
            if (!nodesToConsider.contains(nodeName) || n.getNodeProperty(DisablePrePostCleanNodeProperty.class) == null) continue;
            result.add(nodeName);
        }
        String nodeName = "";
        if (nodesToConsider.contains("") && jenkins.getNodeProperty(DisablePrePostCleanNodeProperty.class) != null) {
            result.add("");
        }
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(PrePostClean.class);
        }

        public String getDisplayName() {
            return Messages.PrePostClean_displayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

