/*
 * Decompiled with CFR 0.152.
 */
package de.jamba.hudson.plugin.wsclean;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import de.jamba.hudson.plugin.wsclean.Messages;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class CommonConfig
extends GlobalConfiguration {
    private static final char LINE_SEPARATOR = '\n';
    private static final Joiner LINE_JOINER = Joiner.on((char)'\n').skipNulls();
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();
    private static final NodeSelection DEFAULT_NODESELECTION = NodeSelection.LABEL_ONLY;
    private static final boolean DEFAULT_SKIPROAMING = true;
    private static final boolean DEFAULT_PARALLEL = true;
    private static final String[] DEFAULT_NODENAMESTOSKIP = new String[0];
    private static final long DEFAULT_TIMEOUTINMILLISECONDS = 900000L;
    private NodeSelection nodeSelection = null;
    private boolean skipRoaming = true;
    private boolean parallel = true;
    private String[] nodeNamesToSkip = DEFAULT_NODENAMESTOSKIP;
    private transient Pattern[] nodeNamesToSkipPatterns;
    private long timeoutInMilliseconds = 900000L;

    public static CommonConfig get() {
        return (CommonConfig)((Object)GlobalConfiguration.all().get(CommonConfig.class));
    }

    public CommonConfig() {
        this.load();
    }

    @Nonnull
    public NodeSelection getNodeSelection() {
        return this.nodeSelection == null ? DEFAULT_NODESELECTION : this.nodeSelection;
    }

    @DataBoundSetter
    public void setNodeSelection(NodeSelection nodeSelection) {
        this.nodeSelection = nodeSelection;
        this.save();
    }

    public boolean getSkipRoaming() {
        return this.skipRoaming;
    }

    @DataBoundSetter
    public void setSkipRoaming(boolean skipRoaming) {
        this.skipRoaming = skipRoaming;
        this.save();
    }

    public boolean getParallel() {
        return this.parallel;
    }

    @DataBoundSetter
    public void setParallel(boolean parallel) {
        this.parallel = parallel;
        this.save();
    }

    @Nonnull
    public String[] getNodeNamesToSkip() {
        return this.nodeNamesToSkip == null ? new String[]{} : Arrays.copyOf(this.nodeNamesToSkip, this.nodeNamesToSkip.length);
    }

    public String getNodeNamesToSkipString() {
        return LINE_JOINER.join((Object[])this.getNodeNamesToSkip());
    }

    @Restricted(value={NoExternalUse.class})
    Pattern[] getNodeNamesToSkipPatterns() {
        return this.nodeNamesToSkipPatterns == null ? new Pattern[]{} : this.nodeNamesToSkipPatterns;
    }

    @DataBoundSetter
    public void setNodeNamesToSkip(String[] nodeNamesToSkip) {
        ArrayList patterns;
        if (nodeNamesToSkip == null) {
            patterns = Lists.newArrayList();
            this.nodeNamesToSkip = new String[0];
        } else {
            int length = nodeNamesToSkip.length;
            patterns = Lists.newArrayListWithCapacity((int)length);
            for (String nodeNameToSkip : nodeNamesToSkip) {
                try {
                    Pattern p = Pattern.compile(nodeNameToSkip);
                    patterns.add(p);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            this.nodeNamesToSkip = Arrays.copyOf(nodeNamesToSkip, length);
        }
        this.nodeNamesToSkipPatterns = patterns.toArray(new Pattern[patterns.size()]);
        this.save();
    }

    @DataBoundSetter
    public void setNodeNamesToSkipString(String nodeNamesToSkipString) {
        this.setNodeNamesToSkip(CommonConfig.splitAndFilterEmpty(nodeNamesToSkipString));
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds < 0L ? 0L : this.timeoutInMilliseconds;
    }

    @DataBoundSetter
    public void setTimeoutInMilliseconds(long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public FormValidation doCheckSkipRoaming(@QueryParameter boolean value, @QueryParameter String nodeSelection) {
        NodeSelection nodeSelectionEnum;
        try {
            nodeSelectionEnum = NodeSelection.valueOf(nodeSelection);
        }
        catch (IllegalArgumentException ex) {
            nodeSelectionEnum = null;
        }
        if (NodeSelection.HISTORY_ONLY.equals((Object)nodeSelectionEnum)) {
            return FormValidation.warning((String)Messages.CommonConfig_skipRoamingIgnores());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckNodeNamesToSkipString(@QueryParameter String value) {
        String[] values = CommonConfig.splitAndFilterEmpty(value);
        ArrayList warnings = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        for (int i = 0; i < values.length; ++i) {
            int number = i + 1;
            String thisValue = values[i];
            if (thisValue.startsWith(" ")) {
                warnings.add(Messages.CommonConfig_nodeNamesToSkip_whitespaceFirst(number));
            }
            if (thisValue.endsWith(" ")) {
                warnings.add(Messages.CommonConfig_nodeNamesToSkip_whitespaceLast(number));
            }
            try {
                Pattern.compile(thisValue);
                continue;
            }
            catch (PatternSyntaxException ex) {
                errors.add(Messages.CommonConfig_nodeNamesToSkip_invalid(number, ex.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            return FormValidation.error((String)((String)errors.get(0)));
        }
        if (!warnings.isEmpty()) {
            return FormValidation.warning((String)((String)warnings.get(0)));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckTimeoutInMilliseconds(@QueryParameter String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    private static String[] splitAndFilterEmpty(String s) {
        ArrayList result = Lists.newArrayList();
        if (s != null) {
            for (String o : LINE_SPLITTER.split((CharSequence)s)) {
                result.add(o);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static enum NodeSelection {
        LABEL_ONLY(true, false, Messages._NodeSelection_LABEL_ONLY_displayName()),
        HISTORY_ONLY(false, true, Messages._NodeSelection_HISTORY_ONLY_displayName()),
        LABEL_AND_HISTORY(true, true, Messages._NodeSelection_LABEL_AND_HISTORY_displayName());

        private final boolean labels;
        private final boolean history;
        private final Localizable description;

        private NodeSelection(boolean labels, boolean history, Localizable description) {
            this.labels = labels;
            this.history = history;
            this.description = description;
        }

        public String getDescription() {
            return this.description.toString();
        }

        public boolean getUseLabels() {
            return this.labels;
        }

        public boolean getUseHistory() {
            return this.history;
        }
    }
}

