// CHECKSTYLE:OFF

package de.jamba.hudson.plugin.wsclean;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PrePostClean.displayName}: {@code Clean up this job's
     * workspaces from other slave nodes.}.
     * 
     * @return
     *     {@code Clean up this job's workspaces from other slave nodes.}
     */
    public static String PrePostClean_displayName() {
        return holder.format("PrePostClean.displayName");
    }

    /**
     * Key {@code PrePostClean.displayName}: {@code Clean up this job's
     * workspaces from other slave nodes.}.
     * 
     * @return
     *     {@code Clean up this job's workspaces from other slave nodes.}
     */
    public static Localizable _PrePostClean_displayName() {
        return new Localizable(holder, "PrePostClean.displayName");
    }

    /**
     * Key {@code NodeSelection.LABEL_ONLY.displayName}: {@code Clean nodes
     * that could be used}.
     * 
     * @return
     *     {@code Clean nodes that could be used}
     */
    public static String NodeSelection_LABEL_ONLY_displayName() {
        return holder.format("NodeSelection.LABEL_ONLY.displayName");
    }

    /**
     * Key {@code NodeSelection.LABEL_ONLY.displayName}: {@code Clean nodes
     * that could be used}.
     * 
     * @return
     *     {@code Clean nodes that could be used}
     */
    public static Localizable _NodeSelection_LABEL_ONLY_displayName() {
        return new Localizable(holder, "NodeSelection.LABEL_ONLY.displayName");
    }

    /**
     * Key {@code NodeSelection.LABEL_AND_HISTORY.displayName}: {@code Clean
     * nodes that could be, or have been, used}.
     * 
     * @return
     *     {@code Clean nodes that could be, or have been, used}
     */
    public static String NodeSelection_LABEL_AND_HISTORY_displayName() {
        return holder.format("NodeSelection.LABEL_AND_HISTORY.displayName");
    }

    /**
     * Key {@code NodeSelection.LABEL_AND_HISTORY.displayName}: {@code Clean
     * nodes that could be, or have been, used}.
     * 
     * @return
     *     {@code Clean nodes that could be, or have been, used}
     */
    public static Localizable _NodeSelection_LABEL_AND_HISTORY_displayName() {
        return new Localizable(holder, "NodeSelection.LABEL_AND_HISTORY.displayName");
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.whitespaceLast}: {@code
     * Regex#{0} has trailing whitespace}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} has trailing whitespace}
     */
    public static String CommonConfig_nodeNamesToSkip_whitespaceLast(Object arg0) {
        return holder.format("CommonConfig.nodeNamesToSkip.whitespaceLast", arg0);
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.whitespaceLast}: {@code
     * Regex#{0} has trailing whitespace}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} has trailing whitespace}
     */
    public static Localizable _CommonConfig_nodeNamesToSkip_whitespaceLast(Object arg0) {
        return new Localizable(holder, "CommonConfig.nodeNamesToSkip.whitespaceLast", arg0);
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.invalid}: {@code Regex#{0} is
     * not a valid regex: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} is not a valid regex: {1}}
     */
    public static String CommonConfig_nodeNamesToSkip_invalid(Object arg0, Object arg1) {
        return holder.format("CommonConfig.nodeNamesToSkip.invalid", arg0, arg1);
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.invalid}: {@code Regex#{0} is
     * not a valid regex: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} is not a valid regex: {1}}
     */
    public static Localizable _CommonConfig_nodeNamesToSkip_invalid(Object arg0, Object arg1) {
        return new Localizable(holder, "CommonConfig.nodeNamesToSkip.invalid", arg0, arg1);
    }

    /**
     * Key {@code NodeSelection.HISTORY_ONLY.displayName}: {@code Clean nodes
     * that have been used}.
     * 
     * @return
     *     {@code Clean nodes that have been used}
     */
    public static String NodeSelection_HISTORY_ONLY_displayName() {
        return holder.format("NodeSelection.HISTORY_ONLY.displayName");
    }

    /**
     * Key {@code NodeSelection.HISTORY_ONLY.displayName}: {@code Clean nodes
     * that have been used}.
     * 
     * @return
     *     {@code Clean nodes that have been used}
     */
    public static Localizable _NodeSelection_HISTORY_ONLY_displayName() {
        return new Localizable(holder, "NodeSelection.HISTORY_ONLY.displayName");
    }

    /**
     * Key {@code DisablePrePostCleanNodeProperty.displayName}: {@code Skip
     * this node when cleaning old build workspaces.}.
     * 
     * @return
     *     {@code Skip this node when cleaning old build workspaces.}
     */
    public static String DisablePrePostCleanNodeProperty_displayName() {
        return holder.format("DisablePrePostCleanNodeProperty.displayName");
    }

    /**
     * Key {@code DisablePrePostCleanNodeProperty.displayName}: {@code Skip
     * this node when cleaning old build workspaces.}.
     * 
     * @return
     *     {@code Skip this node when cleaning old build workspaces.}
     */
    public static Localizable _DisablePrePostCleanNodeProperty_displayName() {
        return new Localizable(holder, "DisablePrePostCleanNodeProperty.displayName");
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.whitespaceFirst}: {@code
     * Regex#{0} has initial whitespace}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} has initial whitespace}
     */
    public static String CommonConfig_nodeNamesToSkip_whitespaceFirst(Object arg0) {
        return holder.format("CommonConfig.nodeNamesToSkip.whitespaceFirst", arg0);
    }

    /**
     * Key {@code CommonConfig.nodeNamesToSkip.whitespaceFirst}: {@code
     * Regex#{0} has initial whitespace}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Regex#{0} has initial whitespace}
     */
    public static Localizable _CommonConfig_nodeNamesToSkip_whitespaceFirst(Object arg0) {
        return new Localizable(holder, "CommonConfig.nodeNamesToSkip.whitespaceFirst", arg0);
    }

    /**
     * Key {@code CommonConfig.skipRoamingIgnores}: {@code This field is
     * ignored when only past workspaces are cleaned.}.
     * 
     * @return
     *     {@code This field is ignored when only past workspaces are cleaned.}
     */
    public static String CommonConfig_skipRoamingIgnores() {
        return holder.format("CommonConfig.skipRoamingIgnores");
    }

    /**
     * Key {@code CommonConfig.skipRoamingIgnores}: {@code This field is
     * ignored when only past workspaces are cleaned.}.
     * 
     * @return
     *     {@code This field is ignored when only past workspaces are cleaned.}
     */
    public static Localizable _CommonConfig_skipRoamingIgnores() {
        return new Localizable(holder, "CommonConfig.skipRoamingIgnores");
    }

    /**
     * Key {@code PrePostClean.warningNoTimeoutSet}: {@code If no timeout is
     * set then a poorly slave node could cause this build to block
     * indefinitely.}.
     * 
     * @return
     *     {@code If no timeout is set then a poorly slave node could cause this
     *     build to block indefinitely.}
     */
    public static String PrePostClean_warningNoTimeoutSet() {
        return holder.format("PrePostClean.warningNoTimeoutSet");
    }

    /**
     * Key {@code PrePostClean.warningNoTimeoutSet}: {@code If no timeout is
     * set then a poorly slave node could cause this build to block
     * indefinitely.}.
     * 
     * @return
     *     {@code If no timeout is set then a poorly slave node could cause this
     *     build to block indefinitely.}
     */
    public static Localizable _PrePostClean_warningNoTimeoutSet() {
        return new Localizable(holder, "PrePostClean.warningNoTimeoutSet");
    }

}
