/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.EnvVars;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class GradleInstallation
extends ToolInstallation
implements EnvironmentSpecific<GradleInstallation>,
NodeSpecific<GradleInstallation> {
    public static final String UNIX_GRADLE_COMMAND = "gradle";
    public static final String WINDOWS_GRADLE_COMMAND = "gradle.bat";
    public static final String UNIX_GRADLE_WRAPPER_COMMAND = "gradlew";
    public static final String WINDOWS_GRADLE_WRAPPER_COMMAND = "gradlew.bat";
    private final String gradleHome = super.getHome();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GradleInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, GradleInstallation.launderHome((String)home), properties);
    }

    private static String launderHome(String home) {
        if (home.endsWith("/") || home.endsWith("\\")) {
            return home.substring(0, home.length() - 1);
        }
        return home;
    }

    public String getHome() {
        if (this.gradleHome != null) {
            return this.gradleHome;
        }
        return super.getHome();
    }

    public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getWrapperExecutable(Launcher launcher, AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private File getExeFile() {
        String execName = Functions.isWindows() ? "gradle.bat" : "gradle";
        String antHome = Util.replaceMacro((String)this.gradleHome, (Map)EnvVars.masterEnvVars);
        return new File(antHome, "bin/" + execName);
    }

    private File getWrapperExeFile(AbstractBuild<?, ?> build) {
        String execName = Functions.isWindows() ? "gradlew.bat" : "gradlew";
        return new File(build.getModuleRoot().getRemote(), execName);
    }

    public GradleInstallation forEnvironment(EnvVars environment) {
        return new GradleInstallation(this.getName(), environment.expand(this.gradleHome), this.getProperties().toList());
    }

    public GradleInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new GradleInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    static /* synthetic */ File access$000(GradleInstallation x0) {
        return x0.getExeFile();
    }

    static /* synthetic */ File access$100(GradleInstallation x0, AbstractBuild x1) {
        return x0.getWrapperExeFile(x1);
    }
}

