/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gradle
extends Builder {
    private final String description;
    private final String switches;
    private final String tasks;
    private final String rootBuildScriptDir;
    private final String buildFile;
    private final String gradleName;
    private final boolean useWrapper;
    private static final String JAVA_OPTS_KEY = "JAVA_OPTS";

    @DataBoundConstructor
    public Gradle(String description, String switches, String tasks, String rootBuildScriptDir, String buildFile, String gradleName, boolean useWrapper) {
        this.description = description;
        this.switches = switches;
        this.tasks = tasks;
        this.gradleName = gradleName;
        this.rootBuildScriptDir = rootBuildScriptDir;
        this.buildFile = buildFile;
        this.useWrapper = !useWrapper;
    }

    public String getSwitches() {
        return this.switches;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getGradleName() {
        return this.gradleName;
    }

    public String getTasks() {
        return this.tasks;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    public String getRootBuildScriptDir() {
        return this.rootBuildScriptDir;
    }

    public GradleInstallation getGradle() {
        for (GradleInstallation i : this.getDescriptor().getInstallations()) {
            if (this.gradleName == null || !i.getName().equals(this.gradleName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath rootLauncher;
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String extraSwitches = (String)env.get((Object)"GRADLE_EXT_SWITCHES");
        String normalizedSwitches = extraSwitches != null ? this.switches + " " + extraSwitches : this.switches;
        normalizedSwitches = normalizedSwitches.replaceAll("[\t\r\n]+", " ");
        normalizedSwitches = Util.replaceMacro((String)normalizedSwitches, (Map)env);
        normalizedSwitches = Util.replaceMacro((String)normalizedSwitches, (Map)build.getBuildVariables());
        String extraTasks = (String)env.get((Object)"GRADLE_EXT_TASKS");
        String normalizedTasks = extraTasks != null ? this.tasks + " " + extraTasks : this.tasks;
        normalizedTasks = normalizedTasks.replaceAll("[\t\r\n]+", " ");
        ArgumentListBuilder args = new ArgumentListBuilder();
        GradleInstallation ai = this.getGradle();
        if (ai == null) {
            if (this.useWrapper) {
                String execName = Functions.isWindows() ? "gradlew.bat" : "gradlew";
                FilePath workspace = build.getModuleRoot();
                File gradleWrapperFile = new File(workspace.getRemote(), execName);
                args.add(gradleWrapperFile.getAbsolutePath());
            } else {
                args.add(launcher.isUnix() ? "gradle" : "gradle.bat");
            }
        } else {
            ai = ai.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            ai = ai.forEnvironment(env);
            String exe = this.useWrapper ? ai.getWrapperExecutable(launcher, build) : ai.getExecutable(launcher);
            if (exe == null) {
                listener.fatalError("ERROR");
                return false;
            }
            args.add(exe);
        }
        args.addKeyValuePairs("-D", build.getBuildVariables());
        args.addTokenized(normalizedSwitches);
        args.addTokenized(normalizedTasks);
        if (this.buildFile != null && this.buildFile.trim().length() != 0) {
            String buildFileNormalized = Util.replaceMacro((String)this.buildFile.trim(), (Map)env);
            args.add("-b");
            args.add(buildFileNormalized);
        }
        if (ai != null) {
            env.put("GRADLE_HOME", ai.getHome());
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        if (this.rootBuildScriptDir != null && this.rootBuildScriptDir.trim().length() != 0) {
            String rootBuildScriptNormalized = Util.replaceMacro((String)this.rootBuildScriptDir.trim(), (Map)env);
            rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptNormalized, (VariableResolver)build.getBuildVariableResolver());
            rootLauncher = new FilePath(build.getModuleRoot(), rootBuildScriptNormalized);
        } else {
            rootLauncher = build.getModuleRoot();
        }
        String javaOpts = (String)env.get((Object)JAVA_OPTS_KEY);
        if (StringUtils.isNotBlank((String)javaOpts)) {
            env.remove((Object)JAVA_OPTS_KEY);
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(rootLauncher).join();
            boolean success = r == 0;
            build.setResult(Result.SUCCESS);
            if (!success) {
                build.setResult(Result.FAILURE);
            }
            return success;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

