/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.parser;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckReport;
import com.thalesgroup.hudson.plugins.cppcheck.exception.CppcheckException;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.jenkinsci.plugins.cppcheck.model.Error;
import com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class CppcheckParser
implements Serializable {
    private static final long serialVersionUID = 1L;

    public CppcheckReport parse(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File input is mandatory.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File input " + file.getName() + " must exist.");
        }
        CppcheckReport cppCheckReport = new CppcheckReport();
        ArrayList<CppcheckFile> everyErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleStyleSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> possibleErrorSeverities = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategorySeverities = new ArrayList<CppcheckFile>();
        try {
            AtomicReference<JAXBContext> jc = new AtomicReference<JAXBContext>();
            jc.set(JAXBContext.newInstance((Class[])new Class[]{Error.class, Results.class}));
            Unmarshaller unmarshaller = ((JAXBContext)jc.get()).createUnmarshaller();
            Results results = (Results)unmarshaller.unmarshal(file);
            for (int i = 0; i < results.getError().size(); ++i) {
                Error error = results.getError().get(i);
                CppcheckFile cppcheckFile = new CppcheckFile();
                cppcheckFile.setFileName(error.getFile());
                String lineAtr = error.getLine();
                if (lineAtr != null) {
                    cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
                }
                cppcheckFile.setCppCheckId(error.getId());
                cppcheckFile.setSeverity(error.getSeverity());
                cppcheckFile.setMessage(error.getMsg());
                if ("possible error".equals(cppcheckFile.getSeverity())) {
                    possibleErrorSeverities.add(cppcheckFile);
                } else if ("style".equals(cppcheckFile.getSeverity())) {
                    styleSeverities.add(cppcheckFile);
                } else if ("possible style".equals(cppcheckFile.getSeverity())) {
                    possibleStyleSeverities.add(cppcheckFile);
                } else if ("error".equals(cppcheckFile.getSeverity())) {
                    errorSeverities.add(cppcheckFile);
                } else {
                    noCategorySeverities.add(cppcheckFile);
                }
                everyErrors.add(cppcheckFile);
            }
        }
        catch (JAXBException jaxbe) {
            throw new CppcheckException("Can't parse cppcheck result file " + file.getPath(), jaxbe);
        }
        cppCheckReport.setEverySeverities(everyErrors);
        cppCheckReport.setPossibleErrorSeverities(possibleErrorSeverities);
        cppCheckReport.setStyleSeverities(styleSeverities);
        cppCheckReport.setPossibleStyleSeverities(possibleStyleSeverities);
        cppCheckReport.setErrorSeverities(errorSeverities);
        cppCheckReport.setNoCategorySeverities(noCategorySeverities);
        return cppCheckReport;
    }
}

