/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cppcheck.model;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import com.thalesgroup.hudson.plugins.cppcheck.util.CppcheckLogger;
import hudson.FilePath;
import hudson.model.BuildListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppcheckSourceContainer {
    private Map<Integer, CppcheckWorkspaceFile> internalMap = new HashMap<Integer, CppcheckWorkspaceFile>();

    public CppcheckSourceContainer(BuildListener listener, FilePath basedir, List<CppcheckFile> files) throws IOException, InterruptedException {
        int key = 1;
        for (CppcheckFile cppcheckFile : files) {
            CppcheckWorkspaceFile cppcheckWorkspaceFile = new CppcheckWorkspaceFile();
            String cppcheckFileName = cppcheckFile.getFileName();
            if (cppcheckFileName == null) {
                cppcheckWorkspaceFile.setFileName(null);
                cppcheckWorkspaceFile.setSourceIgnored(true);
            } else {
                FilePath sourceFilePath = new FilePath(basedir, cppcheckFileName);
                if (!sourceFilePath.exists()) {
                    CppcheckLogger.log(listener, "[WARNING] - The source file '" + sourceFilePath.toURI() + "' doesn't exist on the slave. The ability to display its source code has been removed.");
                    cppcheckWorkspaceFile.setFileName(null);
                    cppcheckWorkspaceFile.setSourceIgnored(true);
                } else if (sourceFilePath.isDirectory()) {
                    cppcheckWorkspaceFile.setFileName(sourceFilePath.getRemote());
                    cppcheckWorkspaceFile.setSourceIgnored(true);
                } else {
                    cppcheckWorkspaceFile.setFileName(sourceFilePath.getRemote());
                    cppcheckWorkspaceFile.setSourceIgnored(false);
                }
            }
            cppcheckFile.setKey(key);
            cppcheckWorkspaceFile.setCppcheckFile(cppcheckFile);
            this.internalMap.put(key, cppcheckWorkspaceFile);
            ++key;
        }
    }

    public Map<Integer, CppcheckWorkspaceFile> getInternalMap() {
        return this.internalMap;
    }
}

