/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.cccc;

import com.thalesgroup.hudson.plugins.cccc.CCCCException;
import com.thalesgroup.hudson.plugins.cccc.CcccAreaRenderer;
import com.thalesgroup.hudson.plugins.cccc.CcccBuildAction;
import com.thalesgroup.hudson.plugins.cccc.CcccReport;
import com.thalesgroup.hudson.plugins.cccc.CcccResult;
import com.thalesgroup.hudson.plugins.cccc.model.ProjectSummary;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class CcccChartBuilder
extends Graph {
    private CcccBuildAction action;

    protected CcccChartBuilder(CcccBuildAction action, int width, int height) {
        super(action.getBuild().getTimestamp(), width, height);
        this.action = action;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = null;
        try {
            chart = ChartFactory.createStackedAreaChart(null, null, (String)"Number of modules", (CategoryDataset)CcccChartBuilder.buildDataset(this.action), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        }
        catch (CCCCException e) {
            e.printStackTrace();
            return null;
        }
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        DefaultCategoryItemRenderer firstRender = new DefaultCategoryItemRenderer();
        CcccAreaRenderer renderer = new CcccAreaRenderer(this.action.getUrlName());
        plot.setRenderer((CategoryItemRenderer)firstRender);
        NumberAxis axis2 = new NumberAxis("Lines of Code");
        axis2.setLabelPaint((Paint)Color.BLUE);
        axis2.setAxisLinePaint((Paint)Color.BLUE);
        axis2.setTickLabelPaint((Paint)Color.BLUE);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        categoryPlot.setRangeAxis(1, (ValueAxis)axis2);
        categoryPlot.setDataset(1, CcccChartBuilder.buildDataset2(this.action));
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        DefaultCategoryItemRenderer rendu = new DefaultCategoryItemRenderer();
        rendu.setBasePaint((Paint)Color.BLUE);
        categoryPlot.setRenderer(1, (CategoryItemRenderer)rendu);
        NumberAxis axis3 = new NumberAxis("McCabe's Cyclomatic Number");
        axis3.setLabelPaint((Paint)Color.GREEN);
        axis3.setAxisLinePaint((Paint)Color.GREEN);
        axis3.setTickLabelPaint((Paint)Color.GREEN);
        CategoryPlot categoryPlot3 = chart.getCategoryPlot();
        categoryPlot3.setRangeAxis(2, (ValueAxis)axis3);
        categoryPlot3.setDataset(2, CcccChartBuilder.buildDataset3(this.action));
        categoryPlot3.mapDatasetToRangeAxis(2, 2);
        categoryPlot3.mapDatasetToDomainAxis(2, 0);
        DefaultCategoryItemRenderer rendu3 = new DefaultCategoryItemRenderer();
        rendu3.setBasePaint((Paint)Color.GREEN);
        categoryPlot3.setRenderer(2, (CategoryItemRenderer)rendu3);
        return chart;
    }

    private static CategoryDataset buildDataset(CcccBuildAction lastAction) throws CCCCException {
        DataSetBuilder builder = new DataSetBuilder();
        CcccBuildAction action = lastAction;
        do {
            CcccResult result;
            if ((result = action.getResult()) == null) continue;
            CcccReport report = result.getReport();
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            try {
                Class<ProjectSummary> projectSummaryClass = ProjectSummary.class;
                Method method = projectSummaryClass.getMethod("nbNodules", new Class[0]);
                Number n = (Number)method.invoke(report.getStructuralSummaryModuleList(), new Object[0]);
            }
            catch (NoSuchMethodException nse) {
                throw new CCCCException(nse);
            }
            catch (IllegalAccessException iae) {
                throw new CCCCException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new CCCCException(ite);
            }
            if (report.getProjectSummary() == null) {
                builder.add((Number)0, (Comparable)((Object)"Number of module"), (Comparable)buildLabel);
                continue;
            }
            builder.add((Number)report.getProjectSummary().getNbModules(), (Comparable)((Object)"Number of module"), (Comparable)buildLabel);
        } while ((action = action.getPreviousAction()) != null);
        return builder.build();
    }

    private static CategoryDataset buildDataset2(CcccBuildAction lastAction) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        CcccBuildAction action = lastAction;
        do {
            CcccResult result;
            if ((result = action.getResult()) == null) continue;
            CcccReport report = result.getReport();
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            if (report.getProjectSummary() == null) {
                dataSetBuilder.add((Number)0, (Comparable)((Object)"Lines of Code"), (Comparable)buildLabel);
                continue;
            }
            dataSetBuilder.add((Number)report.getProjectSummary().getLinesOfCode(), (Comparable)((Object)"Lines of Code"), (Comparable)buildLabel);
        } while ((action = action.getPreviousAction()) != null);
        return dataSetBuilder.build();
    }

    private static CategoryDataset buildDataset3(CcccBuildAction lastAction) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        CcccBuildAction action = lastAction;
        do {
            CcccResult result;
            if ((result = action.getResult()) == null) continue;
            CcccReport report = result.getReport();
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(action.getBuild());
            if (report.getProjectSummary() == null) {
                dataSetBuilder.add((Number)0, (Comparable)((Object)"McCabe's Cyclomatic Number"), (Comparable)buildLabel);
                continue;
            }
            dataSetBuilder.add((Number)report.getProjectSummary().getMcCabesCyclomaticComplexity(), (Comparable)((Object)"McCabe's Cyclomatic Number"), (Comparable)buildLabel);
        } while ((action = action.getPreviousAction()) != null);
        return dataSetBuilder.build();
    }
}

