/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.build_timeout;

import com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.build_timeout.ConditionalTimeout;
import com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.build_timeout.Messages;
import com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.build_timeout.RunConditionTimeoutStrategy;
import com.synopsys.arc.jenkinsci.plugins.run_condition_extras.adapters.build_timeout.Utils;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConditionTimeoutStrategy
extends BuildTimeOutStrategy {
    private static final List<ConditionalTimeout> EMPTY = new ArrayList();
    private final List<ConditionalTimeout> conditions;
    private final long defaultTimeout;
    @Extension(optional=true)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunConditionTimeoutStrategy(List<ConditionalTimeout> conditions, long defaultTimeout) {
        this.conditions = conditions != null ? conditions : EMPTY;
        this.defaultTimeout = defaultTimeout;
    }

    public List<ConditionalTimeout> getConditions() {
        return this.conditions;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public long getTimeOut(Run run) {
        long timeout = this.defaultTimeout;
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            for (ConditionalTimeout condition : this.conditions) {
                if (!condition.isApplicable(build)) continue;
                timeout = condition.getTimeout();
                break;
            }
        } else {
            Utils.logError((String)Messages.RunConditionTimeoutStrategy_classConvError((Object)run.getClass().getCanonicalName()));
        }
        Utils.logMessage((String)Messages.RunConditionTimeoutStrategy_timeoutIs((Object)Long.toString(timeout)));
        return timeout;
    }

    public Descriptor<BuildTimeOutStrategy> getDescriptor() {
        return DESCRIPTOR;
    }
}

