/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller;

import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinInstallation;
import com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller.CygwinKillerInstallation;
import hudson.Plugin;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class CygwinProcessKillerPlugin
extends Plugin {
    private String killScript;
    private boolean enableProcessKiller;
    private CygwinInstallation cygwinInstallation;
    private transient String defaultKillScript;
    public static final String PLUGIN_NAME = "cygwin-process";
    private static final String KILLSCRIPT_NAME = "cygwin_killproc.bash";

    public String getKillScript() {
        return this.killScript;
    }

    public String getDefaultKillScript() {
        return this.defaultKillScript;
    }

    public boolean isEnableProcessKiller() {
        return this.enableProcessKiller;
    }

    public CygwinInstallation getCygwinInstallation() {
        return this.cygwinInstallation;
    }

    public static CygwinProcessKillerPlugin Instance() {
        Plugin plugin = Jenkins.getInstance().getPlugin(CygwinProcessKillerPlugin.class);
        return plugin != null ? (CygwinProcessKillerPlugin)plugin : null;
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.enableProcessKiller = formData.getBoolean("enableProcessKiller");
        this.killScript = formData.getString("killScript");
        this.cygwinInstallation = (CygwinInstallation)req.bindJSON(CygwinInstallation.class, formData.getJSONObject("cygwinInstallation"));
        this.save();
    }

    public void start() throws Exception {
        super.load();
    }

    public void postInitialize() throws Exception {
        InputStream str = CygwinProcessKillerPlugin.class.getResourceAsStream(KILLSCRIPT_NAME);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)str, (Writer)writer);
        this.defaultKillScript = writer.toString();
    }

    public CygwinInstallation.DescriptorImpl getCygwinInstallationDescriptor() {
        return CygwinInstallation.DESCRIPTOR;
    }

    public CygwinKillerInstallation getToolInstallation() {
        CygwinKillerInstallation[] installations;
        if (this.cygwinInstallation == null) {
            return null;
        }
        CygwinKillerInstallation.DescriptorImpl descriptor = (CygwinKillerInstallation.DescriptorImpl)Hudson.getInstance().getDescriptor(CygwinKillerInstallation.class);
        for (CygwinKillerInstallation inst : installations = (CygwinKillerInstallation[])descriptor.getInstallations()) {
            if (!inst.getName().equals(this.cygwinInstallation.getName())) continue;
            return inst;
        }
        return null;
    }
}

