// CHECKSTYLE:OFF

package com.synopsys.arc.jenkinsci.plugins.cygwinprocesskiller;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Cannot check the Cygwin platform. 
     * 
     */
    public static String Message_CygwinCheckFailed() {
        return holder.format("Message.CygwinCheckFailed");
    }

    /**
     * Cannot check the Cygwin platform. 
     * 
     */
    public static Localizable _Message_CygwinCheckFailed() {
        return new Localizable(holder, "Message.CygwinCheckFailed");
    }

    /**
     * Cannot install Cygwin from Custom Tools. 
     * 
     */
    public static String Message_InstallationFailed() {
        return holder.format("Message.InstallationFailed");
    }

    /**
     * Cannot install Cygwin from Custom Tools. 
     * 
     */
    public static Localizable _Message_InstallationFailed() {
        return new Localizable(holder, "Message.InstallationFailed");
    }

    /**
     * Killer is disabled
     * 
     */
    public static String Message_KillerIsDisabled() {
        return holder.format("Message.KillerIsDisabled");
    }

    /**
     * Killer is disabled
     * 
     */
    public static Localizable _Message_KillerIsDisabled() {
        return new Localizable(holder, "Message.KillerIsDisabled");
    }

    /**
     * Cygwin Killer
     * 
     */
    public static String CygwinKillerInstallation_DisplayName() {
        return holder.format("CygwinKillerInstallation.DisplayName");
    }

    /**
     * Cygwin Killer
     * 
     */
    public static Localizable _CygwinKillerInstallation_DisplayName() {
        return new Localizable(holder, "CygwinKillerInstallation.DisplayName");
    }

    /**
     * Cygwin Process Killer cannot kill the process tree (parent pid="+{0}+")
     * 
     */
    public static String Message_ProcessKillFailed(Object arg1) {
        return holder.format("Message.ProcessKillFailed", arg1);
    }

    /**
     * Cygwin Process Killer cannot kill the process tree (parent pid="+{0}+")
     * 
     */
    public static Localizable _Message_ProcessKillFailed(Object arg1) {
        return new Localizable(holder, "Message.ProcessKillFailed", arg1);
    }

    /**
     * Cannot locate Cygwin on the host
     * 
     */
    public static String Message_CannotFindCygwin() {
        return holder.format("Message.CannotFindCygwin");
    }

    /**
     * Cannot locate Cygwin on the host
     * 
     */
    public static Localizable _Message_CannotFindCygwin() {
        return new Localizable(holder, "Message.CannotFindCygwin");
    }

}
