/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import hudson.EnvVars;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.tools.ToolInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class EnvStringParseHelper {
    private EnvStringParseHelper() {
    }

    public static String substituteEnvVars(String macroString, EnvVars environment) {
        if (macroString == null) {
            return null;
        }
        if (!macroString.contains("${")) {
            return macroString;
        }
        return environment.expand(macroString);
    }

    public static String substituteNodeVariablesValidated(ToolInstaller installer, String stringName, String macroString, Node node) throws ExtraToolInstallersException {
        String res = EnvStringParseHelper.substituteNodeVariables((String)macroString, (Node)node);
        EnvStringParseHelper.checkStringForMacro((ToolInstaller)installer, (String)stringName, (String)res);
        return res;
    }

    public static String substituteNodeVariables(String macroString, Node node) {
        if (macroString == null) {
            return null;
        }
        if (!macroString.contains("${")) {
            return macroString;
        }
        String substitutedString = macroString;
        for (NodeProperty entry : node.getNodeProperties()) {
            substitutedString = EnvStringParseHelper.substituteNodeProperty((String)substitutedString, (NodeProperty)entry);
        }
        for (NodeProperty entry : Hudson.getInstance().getGlobalNodeProperties()) {
            substitutedString = EnvStringParseHelper.substituteNodeProperty((String)substitutedString, (NodeProperty)entry);
        }
        return substitutedString;
    }

    public static String substituteNodeProperty(String macroString, NodeProperty<?> property) {
        if (EnvironmentVariablesNodeProperty.class.equals(property.getClass())) {
            EnvironmentVariablesNodeProperty prop = (EnvironmentVariablesNodeProperty)property;
            return EnvStringParseHelper.substituteEnvVars((String)macroString, (EnvVars)prop.getEnvVars());
        }
        return macroString;
    }

    public static void checkStringForMacro(ToolInstaller installer, String stringName, String macroString) throws ExtraToolInstallersException {
        if (macroString.contains("${")) {
            throw new ExtraToolInstallersException(installer, "Can't resolve all variables in " + stringName + " string. Final state: " + macroString);
        }
    }
}

