/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.dynamic_search.views;

import com.synopsys.arc.jenkinsci.plugins.dynamic_search.views.JobsFilter;
import com.synopsys.arc.jenkinsci.plugins.dynamic_search.views.Messages;
import com.synopsys.arc.jenkinsci.plugins.dynamic_search.views.UserContext;
import com.synopsys.arc.jenkinsci.plugins.dynamic_search.views.UserContextCache;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ListView;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.search.Search;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearchView
extends ListView {
    transient UserContextCache contextMap;
    private String defaultIncludeRegex;
    private DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> defaultJobFilters;

    @DataBoundConstructor
    public SimpleSearchView(String name) {
        super(name);
    }

    public String getDefaultIncludeRegex() {
        return this.defaultIncludeRegex;
    }

    public DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> getDefaultJobFilters() {
        return this.defaultJobFilters;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        if (this.defaultJobFilters == null) {
            this.defaultJobFilters = new DescribableList((Saveable)this);
        }
        this.defaultJobFilters.rebuildHetero(req, req.getSubmittedForm(), (Collection)ViewJobFilter.all(), "defaultJobFilters");
        this.defaultIncludeRegex = Util.fixEmpty((String)req.getParameter("defaultIncludeRegex").toString());
    }

    public static String getSessionId() {
        return Stapler.getCurrentRequest().getSession().getId();
    }

    public Search getSearch() {
        return super.getSearch();
    }

    public boolean hasConfiguredFilters() {
        return this.contextMap != null && this.contextMap.containsKey(SimpleSearchView.getSessionId());
    }

    public JobsFilter getFilters() {
        return this.hasConfiguredFilters() ? this.contextMap.get(SimpleSearchView.getSessionId()).getFiltersConfig() : this.getDefaultFilters();
    }

    public JobsFilter getDefaultFilters() {
        return new JobsFilter((View)this, this.defaultJobFilters.getAll(ViewJobFilter.class), this.defaultIncludeRegex, null);
    }

    public boolean isAutomaticRefreshEnabled() {
        return false;
    }

    public boolean isAutoRefreshActive() {
        return true;
    }

    public String cleanCache() {
        String sessionId = SimpleSearchView.getSessionId();
        if (this.hasConfiguredFilters()) {
            this.contextMap.flush(sessionId);
        }
        return sessionId;
    }

    public List<TopLevelItem> getItems() {
        List res = super.getItems();
        JobsFilter filters = this.getFilters();
        return filters.doFilter(res, (View)this);
    }

    public void doSearchSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(View.READ);
        SearchAction action = SearchAction.fromRequest(req);
        switch (action) {
            case runSearchButton: {
                JobsFilter filter = new JobsFilter(req, (View)this);
                this.updateSearchCache(filter);
                rsp.sendRedirect(".");
                break;
            }
            case resetDefaultsButton: {
                this.updateSearchCache(this.getDefaultFilters());
                rsp.sendRedirect(".");
                break;
            }
            default: {
                throw new IOException("Action " + (Object)((Object)action) + " is not supported");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchCache(JobsFilter filter) {
        if (this.contextMap == null) {
            SimpleSearchView simpleSearchView = this;
            synchronized (simpleSearchView) {
                this.contextMap = new UserContextCache();
            }
        }
        this.contextMap.put(SimpleSearchView.getSessionId(), new UserContext(filter));
    }

    public boolean hasUserJobFilterExtensions() {
        return !ViewJobFilter.all().isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SearchAction {
        runSearchButton,
        resetDefaultsButton;


        static SearchAction fromRequest(StaplerRequest req) throws IOException {
            Map map = req.getParameterMap();
            for (SearchAction val : SearchAction.values()) {
                if (!map.containsKey(val.toString())) continue;
                return val;
            }
            throw new IOException("Cannot find an action in the reqest");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.SimpleSearchView_displayName();
        }

        public FormValidation doCheckDefaultIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            return this.doCheckIncludeRegex(value);
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

