/*
 * Decompiled with CFR 0.152.
 */
package com.suryagaddipati.jenkins;

import com.suryagaddipati.jenkins.SlaveUtilizationProperty;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;

@Extension
public class SlaveUtilizationQueueTaskDispatcher
extends QueueTaskDispatcher {
    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        AbstractProject project;
        if (item.task instanceof AbstractProject && (this.isRestrictrictedToRunOnlyOneInstancePerNode(project = (AbstractProject)item.task, node) || !this.isRequestedCapacityAvailable(node, project))) {
            return new CauseOfBlockage.BecauseNodeIsBusy(node);
        }
        return super.canTake(node, item);
    }

    private boolean isRestrictrictedToRunOnlyOneInstancePerNode(AbstractProject project, Node node) {
        SlaveUtilizationProperty property = (SlaveUtilizationProperty)project.getProperty(SlaveUtilizationProperty.class);
        if (property != null && property.isSingleInstancePerSlave()) {
            for (Executor executor : node.toComputer().getExecutors()) {
                AbstractBuild currentlyRunningBuild;
                if (executor.getCurrentExecutable() == null || !(executor.getCurrentExecutable() instanceof AbstractBuild) || !(currentlyRunningBuild = (AbstractBuild)executor.getCurrentExecutable()).getProject().getName().equals(project.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRequestedCapacityAvailable(Node node, AbstractProject project) {
        float requestedPercentage = this.getProjectNodeSlice(project, node);
        return this.availableCapacity(node) >= requestedPercentage;
    }

    private float availableCapacity(Node node) {
        return 100.0f - this.currentlyRunningJobCapacity(node);
    }

    private float currentlyRunningJobCapacity(Node node) {
        float currentRunningCapacity = 0.0f;
        for (Executor executor : node.toComputer().getExecutors()) {
            Queue.Executable currentExecutable = executor.getCurrentExecutable();
            if (currentExecutable == null || !(currentExecutable instanceof Build)) continue;
            currentRunningCapacity += this.getProjectNodeSlice(((Build)currentExecutable).getProject(), node);
        }
        return currentRunningCapacity;
    }

    private float getProjectNodeSlice(AbstractProject executable, Node node) {
        AbstractProject project = executable instanceof MatrixConfiguration ? ((MatrixConfiguration)executable).getParent() : executable;
        SlaveUtilizationProperty property = (SlaveUtilizationProperty)project.getProperty(SlaveUtilizationProperty.class);
        return property != null && property.isNeedsExclusiveAccessToNode() ? (float)property.getSlaveUtilizationPercentage() : this.nodeUtilizationPerNotGreedyJob(node);
    }

    private float nodeUtilizationPerNotGreedyJob(Node node) {
        return node.toComputer().getNumExecutors() > 0 ? (float)(100 / node.toComputer().getNumExecutors()) : 0.0f;
    }
}

