/*
 * Decompiled with CFR 0.152.
 */
package com.suryagaddipati.jenkins;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveUtilizationProperty
extends JobProperty<Job<?, ?>> {
    private final boolean needsExclusiveAccessToNode;
    private final boolean singleInstancePerSlave;
    private final int slaveUtilizationPercentage;

    public SlaveUtilizationProperty(boolean needsExclusiveAccessToNode, int slaveUtilizationPercentage, boolean singleInstancePerSlave) {
        this.needsExclusiveAccessToNode = needsExclusiveAccessToNode;
        this.slaveUtilizationPercentage = slaveUtilizationPercentage;
        this.singleInstancePerSlave = singleInstancePerSlave;
    }

    public boolean isNeedsExclusiveAccessToNode() {
        return this.needsExclusiveAccessToNode;
    }

    public int getSlaveUtilizationPercentage() {
        return this.slaveUtilizationPercentage;
    }

    public boolean isSingleInstancePerSlave() {
        return this.singleInstancePerSlave;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class ExclusiveAccessPropertyDescriptor
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "Needs exclusive access to Node";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public SlaveUtilizationProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            boolean needsExclusiveAccessToNode = formData.containsKey((Object)"needsExclusiveAccessToNode");
            boolean singleInstancePerSlave = formData.containsKey((Object)"singleInstancePerSlave");
            int requestedSlaveUtilizationPercentage = needsExclusiveAccessToNode ? Integer.parseInt((String)((Map)formData.get("needsExclusiveAccessToNode")).get("slaveUtilizationPercentage")) : 0;
            return new SlaveUtilizationProperty(needsExclusiveAccessToNode, requestedSlaveUtilizationPercentage, singleInstancePerSlave);
        }
    }
}

