/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.google.common.base.Predicate;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.TeeConsoleLogFilter;
import com.splunk.splunkjenkins.listeners.LoggingRunListener;
import com.splunk.splunkjenkins.model.EventType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.RunListener;
import hudson.util.IOUtils;
import hudson.util.NullStream;
import hudson.util.RunList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;

public class BuildInfoArchiver {
    Set<String> processedJob = Collections.newSetFromMap(new WeakHashMap());
    LoggingRunListener runListener = (LoggingRunListener)((Object)RunListener.all().get(LoggingRunListener.class));

    public int run(long startTime, long endTime) {
        List topItems = Jenkins.getInstance().getItems();
        BuildTimePredict predicate = new BuildTimePredict(startTime, endTime);
        int count = 0;
        for (TopLevelItem topLevelItem : topItems) {
            count += this.run((Item)topLevelItem, (Predicate<Run>)predicate);
        }
        return count;
    }

    public int run(String jobName, long startTime, long endTime) {
        Item item = this.normalizeJob(jobName);
        return this.run(item, (Predicate<Run>)new BuildTimePredict(startTime, endTime));
    }

    public int run(String jobName, Predicate<Run> predicate) {
        Item item = this.normalizeJob(jobName);
        return this.run(item, predicate);
    }

    public boolean sendBuild(String buildUrl) {
        if (buildUrl.endsWith("/")) {
            buildUrl = buildUrl.substring(0, buildUrl.length() - 1);
        }
        int idx = buildUrl.lastIndexOf(47);
        String jobName = buildUrl.substring(0, idx);
        int number = Integer.parseInt(buildUrl.substring(idx + 1));
        Item item = this.normalizeJob(jobName);
        boolean sent = false;
        if (item != null && item instanceof Project) {
            AbstractBuild run = ((Project)item).getBuildByNumber(number);
            this.sendBuild((Run)run);
            sent = true;
        }
        return sent;
    }

    public int run(String jobName, int start, int end) {
        Item item = this.normalizeJob(jobName);
        return this.run(item, (Predicate<Run>)new BuildIdPredict(start, end));
    }

    private Item normalizeJob(String jobName) {
        Item item = Jenkins.getInstance().getItem((String)jobName, (ItemGroup)null);
        if (item != null) {
            return item;
        }
        if (!((String)jobName).startsWith("/")) {
            jobName = "/" + (String)jobName;
        }
        String jobPath = ((String)jobName).replace("/job/", "/");
        return Jenkins.getInstance().getItem(jobPath, (ItemGroup)null);
    }

    public int run(Item item, Predicate<Run> predicate) {
        int count;
        block4: {
            block3: {
                if (item == null) {
                    return 0;
                }
                count = 0;
                if (!(item instanceof ItemGroup)) break block3;
                ItemGroup group = (ItemGroup)item;
                for (Object subItem : group.getItems()) {
                    if (!(subItem instanceof Item)) continue;
                    count += this.run((Item)subItem, predicate);
                }
                break block4;
            }
            if (!(item instanceof Project)) break block4;
            Project project = (Project)item;
            RunList runList = project.getBuilds();
            for (Run run : runList) {
                if (this.processedJob.contains(run.getUrl()) || !predicate.apply((Object)run)) continue;
                this.sendBuild(run);
                this.processedJob.add(run.getUrl());
                ++count;
            }
        }
        return count;
    }

    private void sendBuild(Run run) {
        if (run == null || run.isBuilding() || run.getResult() == null) {
            return;
        }
        this.runListener.onCompleted(run, TaskListener.NULL);
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.CONSOLE_LOG)) {
            return;
        }
        try (InputStream input = run.getLogInputStream();){
            TeeConsoleLogFilter.TeeOutputStream outputStream = new TeeConsoleLogFilter.TeeOutputStream((OutputStream)new NullStream(), run.getUrl() + "console");
            IOUtils.copy((InputStream)input, (OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class BuildTimePredict
    implements Predicate<Run> {
        long startTime;
        long endTime;

        public BuildTimePredict(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public boolean apply(@NonNull Run run) {
            long jobTimestamp = run.getStartTimeInMillis() + run.getDuration();
            return jobTimestamp >= this.startTime && jobTimestamp < this.endTime;
        }
    }

    public static class BuildIdPredict
    implements Predicate<Run> {
        int startId;
        int endId;

        public BuildIdPredict(int startId, int endId) {
            this.startId = startId;
            this.endId = endId;
        }

        public boolean apply(@NonNull Run run) {
            return run.getNumber() >= this.startId && run.getNumber() < this.endId;
        }
    }
}

