/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.CoverageMetricsAdapter;
import hudson.Extension;
import hudson.plugins.jacoco.JacocoBuildAction;
import hudson.plugins.jacoco.model.Coverage;
import hudson.plugins.jacoco.model.CoverageObject;
import hudson.plugins.jacoco.report.ClassReport;
import hudson.plugins.jacoco.report.CoverageReport;
import hudson.plugins.jacoco.report.PackageReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(optional=true)
public class JacocoCoverageMetrics
extends CoverageMetricsAdapter<JacocoBuildAction> {
    @Override
    public Map<CoverageMetricsAdapter.Metric, Integer> getMetrics(JacocoBuildAction coverageAction) {
        return this.extract((CoverageObject)coverageAction);
    }

    private Map<CoverageMetricsAdapter.Metric, Integer> extract(CoverageObject coverageObject) {
        HashMap<CoverageMetricsAdapter.Metric, Integer> result = new HashMap<CoverageMetricsAdapter.Metric, Integer>();
        this.addMetric(result, CoverageMetricsAdapter.Metric.CLASS, coverageObject.getClassCoverage());
        this.addMetric(result, CoverageMetricsAdapter.Metric.METHOD, coverageObject.getMethodCoverage());
        this.addMetric(result, CoverageMetricsAdapter.Metric.BRANCH, coverageObject.getBranchCoverage());
        this.addMetric(result, CoverageMetricsAdapter.Metric.COMPLEXITY, coverageObject.getComplexityScore());
        this.addMetric(result, CoverageMetricsAdapter.Metric.INSTRUCTION, coverageObject.getInstructionCoverage());
        this.addMetric(result, CoverageMetricsAdapter.Metric.LINE, coverageObject.getLineCoverage());
        return result;
    }

    private void addMetric(Map<CoverageMetricsAdapter.Metric, Integer> result, CoverageMetricsAdapter.Metric metric, Coverage coverage) {
        if (coverage != null && coverage.getTotal() > 0) {
            result.put(metric, coverage.getPercentage());
        }
    }

    private void appendDetail(CoverageMetricsAdapter.CoverageDetail result, CoverageObject coverageObject) {
        this.appendDetail(result, CoverageMetricsAdapter.Metric.CLASS, coverageObject.getClassCoverage());
        this.appendDetail(result, CoverageMetricsAdapter.Metric.METHOD, coverageObject.getMethodCoverage());
        this.appendDetail(result, CoverageMetricsAdapter.Metric.BRANCH, coverageObject.getBranchCoverage());
        this.appendDetail(result, CoverageMetricsAdapter.Metric.COMPLEXITY, coverageObject.getComplexityScore());
        this.appendDetail(result, CoverageMetricsAdapter.Metric.INSTRUCTION, coverageObject.getInstructionCoverage());
        this.appendDetail(result, CoverageMetricsAdapter.Metric.LINE, coverageObject.getLineCoverage());
    }

    private void appendDetail(CoverageMetricsAdapter.CoverageDetail detail, CoverageMetricsAdapter.Metric reportMetric, Coverage coverage) {
        if (coverage != null && coverage.getTotal() > 0) {
            detail.add(String.valueOf((Object)reportMetric) + "_percentage", coverage.getPercentage());
            detail.add(String.valueOf((Object)reportMetric) + "_total", coverage.getTotal());
            detail.add(String.valueOf((Object)reportMetric) + "_covered", coverage.getCovered());
        }
    }

    @Override
    public List<CoverageMetricsAdapter.CoverageDetail> getReport(JacocoBuildAction coverageAction) {
        CoverageReport report = coverageAction.getResult();
        ArrayList<CoverageMetricsAdapter.CoverageDetail> result = new ArrayList<CoverageMetricsAdapter.CoverageDetail>();
        if (!report.hasChildren()) {
            return result;
        }
        CoverageMetricsAdapter.CoverageDetail summary = new CoverageMetricsAdapter.CoverageDetail("project", CoverageMetricsAdapter.CoverageLevel.PROJECT);
        result.add(summary);
        this.appendDetail(summary, (CoverageObject)coverageAction);
        Map packages = report.getChildren();
        for (Map.Entry entry : packages.entrySet()) {
            CoverageMetricsAdapter.CoverageDetail packageDetail = new CoverageMetricsAdapter.CoverageDetail((String)entry.getKey(), CoverageMetricsAdapter.CoverageLevel.PACKAGE);
            result.add(packageDetail);
            this.appendDetail(packageDetail, (CoverageObject)entry.getValue());
            Map classReports = ((PackageReport)entry.getValue()).getChildren();
            for (Map.Entry classEntry : classReports.entrySet()) {
                CoverageMetricsAdapter.CoverageDetail classDetail = new CoverageMetricsAdapter.CoverageDetail((String)classEntry.getKey(), CoverageMetricsAdapter.CoverageLevel.CLASS);
                result.add(classDetail);
                this.appendDetail(classDetail, (CoverageObject)classEntry.getValue());
                Map methodReports = ((ClassReport)classEntry.getValue()).getChildren();
                for (Map.Entry methodEntry : methodReports.entrySet()) {
                    CoverageMetricsAdapter.CoverageDetail methodDetail = new CoverageMetricsAdapter.CoverageDetail((String)methodEntry.getKey(), CoverageMetricsAdapter.CoverageLevel.METHOD);
                    result.add(methodDetail);
                    this.appendDetail(methodDetail, (CoverageObject)methodEntry.getValue());
                }
            }
        }
        return result;
    }
}

