/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers;

import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import hudson.ExtensionPoint;
import hudson.model.Node;

public abstract class ExternalResourceManager
implements ExtensionPoint {
    public abstract String getDisplayName();

    public StashResult reserve(Node node, ExternalResource resource, int seconds, String reservedBy) {
        StashResult result = this.doReserve(node, resource, seconds, reservedBy);
        if (result != null && result.isOk()) {
            resource.setReserved(new StashInfo(result, reservedBy));
        }
        return result;
    }

    protected abstract StashResult doReserve(Node var1, ExternalResource var2, int var3, String var4);

    public StashResult lock(Node node, ExternalResource resource, String key, String lockedBy) {
        StashResult result = this.doLock(node, resource, key, lockedBy);
        if (result != null && result.isOk()) {
            resource.setLocked(new StashInfo(result, lockedBy));
        }
        return result;
    }

    protected abstract StashResult doLock(Node var1, ExternalResource var2, String var3, String var4);

    public StashResult release(Node node, ExternalResource resource, String key, String releasedBy) {
        StashResult result = this.doRelease(node, resource, key, releasedBy);
        if (result != null && result.isOk()) {
            resource.setReserved(null);
            resource.setLocked(null);
        }
        return result;
    }

    protected abstract StashResult doRelease(Node var1, ExternalResource var2, String var3, String var4);

    public abstract boolean isExternalLockingOk();

    public abstract void updateMetadata(AbstractMetadataValue var1);
}

