/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils;

import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public final class JsonRpcUtil {
    private static final Logger logger = Logger.getLogger(JsonRpcUtil.class.getName());

    private JsonRpcUtil() {
    }

    public static JsonRpcHttpClient createJsonRpcClient(String url) {
        JsonRpcHttpClient client = null;
        try {
            client = new JsonRpcHttpClient(new URL(url));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, MessageFormat.format("Can not create the json rpc client because of malformed url: {0}", url), e);
        }
        return client;
    }

    public static JsonRpcHttpClient createJsonRpcClient(String url, ObjectMapper customizedObjectMapper) {
        JsonRpcHttpClient client = null;
        try {
            client = new JsonRpcHttpClient(customizedObjectMapper, new URL(url), new HashMap());
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, MessageFormat.format("Can not create the json rpc client because of malformed url: {0}", url), e);
        }
        return client;
    }

    public static ObjectMapper customizeObjectMapper() {
        ObjectMapper objMapper = new ObjectMapper(){

            public JsonNode valueToTree(Object params) {
                Object[] paramArray;
                if (params.getClass().isArray() && (paramArray = (Object[])params).length == 1) {
                    return super.valueToTree(paramArray[0]);
                }
                return super.valueToTree(params);
            }
        };
        return objMapper;
    }
}

