/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils;

import com.sonyericsson.hudson.plugins.metadata.model.MetadataNodeProperty;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataParent;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import hudson.model.Node;
import java.util.LinkedList;
import java.util.List;

public final class AvailabilityFilter {
    private static AvailabilityFilter ourInstance = new AvailabilityFilter();

    public static AvailabilityFilter getInstance() {
        return ourInstance;
    }

    private AvailabilityFilter() {
    }

    public ExternalResource getExternalResourceById(Node node, String id) {
        MetadataNodeProperty property = (MetadataNodeProperty)node.getNodeProperties().get(MetadataNodeProperty.class);
        if (property != null) {
            return this.getExternalResourceById((MetadataParent<MetadataValue>)property, id);
        }
        return null;
    }

    public ExternalResource getExternalResourceById(MetadataParent<MetadataValue> parent, String id) {
        if (parent instanceof ExternalResource) {
            ExternalResource resource = (ExternalResource)parent;
            if (resource.getId().equals(id)) {
                return resource;
            }
        } else {
            for (MetadataValue value : parent.getChildren()) {
                ExternalResource resource;
                if (!(value instanceof ExternalResource ? (resource = (ExternalResource)value).getId().equals(id) : value instanceof MetadataParent && (resource = this.getExternalResourceById((MetadataParent<MetadataValue>)((MetadataParent)value), id)) != null)) continue;
                return resource;
            }
        }
        return null;
    }

    public List<ExternalResource> filterEnabledAndAvailable(List<ExternalResource> allResources) {
        LinkedList<ExternalResource> filtered = new LinkedList<ExternalResource>();
        for (ExternalResource resource : allResources) {
            if (!resource.isEnabled() || !resource.isAvailable()) continue;
            filtered.add(resource);
        }
        return filtered;
    }

    public List<ExternalResource> getExternalResourcesList(Node node) {
        MetadataNodeProperty property = (MetadataNodeProperty)node.getNodeProperties().get(MetadataNodeProperty.class);
        if (property != null) {
            LinkedList<ExternalResource> list = new LinkedList<ExternalResource>();
            for (MetadataValue value : property.getChildren()) {
                this.populateExternalResourcesFrom(value, list);
            }
            return list;
        }
        return null;
    }

    private void populateExternalResourcesFrom(MetadataValue value, List<ExternalResource> list) {
        if (value instanceof ExternalResource) {
            list.add((ExternalResource)value);
        } else if (value instanceof MetadataParent) {
            MetadataParent parent = (MetadataParent)value;
            for (MetadataValue child : parent.getChildren()) {
                this.populateExternalResourcesFrom(child, list);
            }
        }
    }
}

