/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import hudson.model.Hudson;
import hudson.model.Node;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AdminNotifier {
    private static final Logger logger = Logger.getLogger(AdminNotifier.class.getName());
    private static AdminNotifier instance = new AdminNotifier();
    private String adminFile = PluginImpl.getInstance().getAdminNotifierFile();
    private RandomAccessFile raf = null;

    public static AdminNotifier getInstance() {
        return instance;
    }

    private AdminNotifier() {
        if (null == this.adminFile || this.adminFile.equals("")) {
            logger.log(Level.WARNING, "Admin Notifier File is not set!");
            String rootDir = Hudson.getInstance().getRootDir().getAbsolutePath();
            String defaultDir = rootDir + "/" + "adminNotifier/notify.csv";
            this.setAdminFile(defaultDir);
        }
        try {
            File p;
            String adminFilePath;
            File file = new File(this.adminFile);
            if (!(file.exists() || null == (adminFilePath = file.getParent()) || adminFilePath.equals("") || (p = new File(adminFilePath)).exists())) {
                boolean result = p.mkdirs();
            }
            this.raf = new RandomAccessFile(this.adminFile, "rw");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to open the Admin Notifier File.", e);
        }
    }

    public void notify(MessageType msgType, OperationType opType, Node node, ExternalResource er, String msg) {
        String resourceId = "";
        if (null != er) {
            resourceId = er.getId();
        }
        String nodeName = node.getDisplayName();
        String message = MessageFormat.format("{0}, {1}, {2}, {3}, {4}, {5}\n", Calendar.getInstance().getTime(), msgType.toString(), resourceId, opType.toString(), nodeName, msg);
        this.recordFile(message);
    }

    private synchronized void recordFile(String msg) {
        try {
            if (this.raf != null) {
                this.raf.seek(this.raf.length());
                this.raf.writeBytes(msg);
            } else {
                logger.log(Level.WARNING, "Failed to record the following message into admin notifier file: {0} since the file couldn't be opened", msg);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, MessageFormat.format("Failed to record the following message into admin notifier file: {0}", msg), e);
        }
    }

    public void setAdminFile(String adminFile) {
        this.adminFile = adminFile;
    }

    public static enum MessageType {
        DEBUG,
        INFO,
        WARNING,
        ERROR;

    }

    public static enum OperationType {
        RESERVE,
        LOCK,
        RELEASE,
        RELEASEALL;

    }
}

