/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.Lease;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;

public class StashInfo
implements Serializable,
Cloneable {
    private String stashedBy;
    private StashType type;
    private Lease lease;
    private String key;

    public StashInfo(StashType type, String stashedBy, Lease lease, String key) {
        this.stashedBy = stashedBy;
        this.type = type;
        this.lease = lease;
        this.key = key;
    }

    public StashInfo(StashResult result, String stashedBy) {
        this.stashedBy = stashedBy;
        this.type = StashType.INTERNAL;
        this.key = result.getKey();
        this.lease = result.getLease();
    }

    public StashInfo clone() throws CloneNotSupportedException {
        StashInfo other = (StashInfo)super.clone();
        if (this.lease != null) {
            other.lease = this.lease.clone();
        }
        return other;
    }

    public String getStashedBy() {
        return this.stashedBy;
    }

    public StashType getType() {
        return this.type;
    }

    public Lease getLease() {
        return this.lease;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isInternal() {
        return this.getType() == StashType.INTERNAL;
    }

    public boolean stashedByIsURL() {
        try {
            URL url = new URL(this.getStashedBy());
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("stashed-by", (Object)this.stashedBy);
        json.put("type", (Object)this.type.name());
        if (this.lease != null) {
            json.put("lease", (Object)this.lease.toJson());
        } else {
            json.put("lease", (Object)new JSONObject(true));
        }
        json.put("key", (Object)this.key);
        return json;
    }

    public static enum StashType {
        INTERNAL,
        EXTERNAL;

    }
}

