/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data;

import com.sonyericsson.hudson.plugins.metadata.model.JsonUtils;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataContainer;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataNodeProperty;
import com.sonyericsson.hudson.plugins.metadata.model.MetadataParent;
import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeNodeMetadataValue;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResourceTreeNode;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@XStreamAlias(value="external-resource")
public class ExternalResource
extends TreeNodeMetadataValue {
    private static final String NO_RESOURCE_MONITOR_EXCEPTION_MSG = "No resource monitor is currently active, this operation is not permitted.";
    private String id;
    private StashInfo reserved;
    private StashInfo locked;
    private Boolean enabled;

    @DataBoundConstructor
    public ExternalResource(String name, String description, String id, Boolean enabled, List<MetadataValue> children) {
        super(name, description, children);
        this.id = id;
        this.enabled = enabled;
    }

    public ExternalResource(String name, String description, String id, List<MetadataValue> children) {
        super(name, description, children);
        this.id = id;
    }

    public ExternalResource(String name, String id, String description) {
        super(name, description);
        this.id = id;
    }

    public ExternalResource(String name, String id, List<MetadataValue> children) {
        super(name, children);
        this.id = id;
    }

    public ExternalResource(String name, String id) {
        super(name);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        super.setName(name);
    }

    public StashInfo getReserved() {
        return this.reserved;
    }

    public void setReserved(StashInfo reserved) {
        this.reserved = reserved;
    }

    public StashInfo getLocked() {
        return this.locked;
    }

    public void setLocked(StashInfo locked) {
        this.locked = locked;
        if (locked != null) {
            this.setReserved(null);
        }
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            return true;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JavaScriptMethod
    public synchronized void doEnable(boolean enable) throws IOException {
        this.getACL().checkPermission(PluginImpl.ENABLE_DISABLE_EXTERNAL_RESOURCE);
        this.setEnabled(enable);
        this.getContainer().save();
    }

    public synchronized void doLock(StashInfo info) throws IOException {
        if (!PluginImpl.getInstance().getManager().isExternalLockingOk()) {
            throw new IllegalStateException(NO_RESOURCE_MONITOR_EXCEPTION_MSG);
        }
        this.getACL().checkPermission(PluginImpl.LOCK_RELEASE_EXTERNAL_RESOURCE);
        this.setLocked(info);
        this.setReserved(null);
        this.getContainer().save();
    }

    public synchronized void doReserve(StashInfo info) throws IOException {
        if (!PluginImpl.getInstance().getManager().isExternalLockingOk()) {
            throw new IllegalStateException(NO_RESOURCE_MONITOR_EXCEPTION_MSG);
        }
        this.getACL().checkPermission(PluginImpl.LOCK_RELEASE_EXTERNAL_RESOURCE);
        this.setReserved(info);
        this.setLocked(null);
        this.getContainer().save();
    }

    public synchronized void doRelease() throws IOException {
        if (!PluginImpl.getInstance().getManager().isExternalLockingOk()) {
            throw new IllegalStateException(NO_RESOURCE_MONITOR_EXCEPTION_MSG);
        }
        this.getACL().checkPermission(PluginImpl.LOCK_RELEASE_EXTERNAL_RESOURCE);
        this.setLocked(null);
        this.setReserved(null);
        this.getContainer().save();
    }

    public synchronized void doExpireReservation() throws IOException {
        this.setReserved(null);
        this.getContainer().save();
    }

    public boolean isAvailable() {
        return this.getReserved() == null && this.getLocked() == null;
    }

    public synchronized ACL getACL() {
        return this.getContainer().getACL();
    }

    public boolean hasEnableDisablePermission() {
        return this.getACL().hasPermission(PluginImpl.ENABLE_DISABLE_EXTERNAL_RESOURCE);
    }

    public boolean canEnableDisable() {
        if (this.hasEnableDisablePermission()) {
            MetadataContainer<MetadataValue> container = this.getContainer();
            return container != null && container instanceof MetadataNodeProperty;
        }
        return false;
    }

    private synchronized MetadataContainer<MetadataValue> getContainer() {
        return this.getContainer((MetadataParent<MetadataValue>)this.getParent());
    }

    private synchronized MetadataContainer<MetadataValue> getContainer(MetadataParent<MetadataValue> parent) {
        if (parent instanceof MetadataContainer) {
            return (MetadataContainer)parent;
        }
        if (parent == null) {
            return null;
        }
        return this.getContainer((MetadataParent<MetadataValue>)((MetadataValue)parent).getParent());
    }

    public Descriptor<AbstractMetadataValue> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(ExternalResourceDescriptor.class);
    }

    public void addEnvironmentVariables(EnvVars variables, boolean exposeAll) {
        super.addEnvironmentVariables(variables, exposeAll);
        if (this.isExposedToEnvironment() || exposeAll) {
            variables.put(this.getEnvironmentName() + "_" + "ID", this.getId());
        }
    }

    public boolean requiresReplacement() {
        return true;
    }

    public void replacementOf(MetadataValue old) {
        super.replacementOf(old);
        if (old instanceof ExternalResource) {
            ExternalResource other = (ExternalResource)old;
            if (this.reserved == null) {
                this.reserved = other.reserved;
            }
            if (this.locked == null) {
                this.locked = other.locked;
            }
            if (this.enabled == null) {
                this.enabled = other.enabled;
            }
            if (this.id == null) {
                this.id = other.id;
            }
        }
    }

    public ExternalResource clone() throws CloneNotSupportedException {
        ExternalResource other = (ExternalResource)super.clone();
        if (this.reserved != null) {
            other.reserved = this.reserved.clone();
        }
        if (this.locked != null) {
            other.locked = this.locked.clone();
        }
        return other;
    }

    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("id", (Object)this.id);
        json.put("enabled", (Object)this.isEnabled());
        if (this.reserved != null) {
            json.put("reserved", (Object)this.reserved.toJson());
        } else {
            json.put("reserved", (Object)new JSONObject(true));
        }
        if (this.locked != null) {
            json.put("locked", (Object)this.locked.toJson());
        } else {
            json.put("locked", (Object)new JSONObject(true));
        }
        return json;
    }

    @Extension
    public static final class ExternalResourceDescriptor
    extends TreeNodeMetadataValue.TreeNodeMetaDataValueDescriptor {
        public String getJsonType() {
            return "external-resource";
        }

        public Permission getDisablePermission() {
            return PluginImpl.ENABLE_DISABLE_EXTERNAL_RESOURCE;
        }

        public MetadataValue fromJson(JSONObject json, MetadataContainer<MetadataValue> container) throws JsonUtils.ParseException {
            JsonUtils.checkRequiredJsonAttribute((JSONObject)json, (String)"id");
            JsonUtils.checkRequiredJsonAttribute((JSONObject)json, (String)"name");
            LinkedList<MetadataValue> children = new LinkedList<MetadataValue>();
            if (json.has("children")) {
                JSONArray array = json.getJSONArray("children");
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject obj = array.getJSONObject(i);
                    children.add(JsonUtils.toValue((JSONObject)obj, container));
                }
            }
            ExternalResource value = new ExternalResource(json.getString("name"), json.optString("description"), json.getString("id"), children);
            if (json.has("enabled")) {
                container.getACL().checkPermission(PluginImpl.ENABLE_DISABLE_EXTERNAL_RESOURCE);
                value.setEnabled(json.getBoolean("enabled"));
            }
            if (json.has("exposedToEnvironment")) {
                value.setExposeToEnvironment(json.getBoolean("exposedToEnvironment"));
            }
            if (json.has("generated")) {
                value.setGenerated(json.getBoolean("generated"));
            } else {
                value.setGenerated(true);
            }
            return value;
        }

        public boolean appliesTo(Descriptor containerDescriptor) {
            return containerDescriptor instanceof ExternalResourceTreeNode.ExternalResourceTreeNodeDescriptor;
        }

        public List<AbstractMetadataValue.AbstractMetaDataValueDescriptor> getValueDescriptors(StaplerRequest request) {
            Object containerObj = request.getAttribute("jenkins-metadata-container");
            request.setAttribute("jenkins-metadata-container", (Object)this);
            Descriptor container = null;
            if (containerObj != null && containerObj instanceof Descriptor) {
                container = (Descriptor)containerObj;
            }
            LinkedList<AbstractMetadataValue.AbstractMetaDataValueDescriptor> list = new LinkedList<AbstractMetadataValue.AbstractMetaDataValueDescriptor>();
            ExtensionList extensionList = Hudson.getInstance().getExtensionList(AbstractMetadataValue.AbstractMetaDataValueDescriptor.class);
            for (AbstractMetadataValue.AbstractMetaDataValueDescriptor d : extensionList) {
                if (d instanceof ExternalResourceDescriptor || !d.appliesTo(container) || !d.appliesTo((Descriptor)this)) continue;
                list.add(d);
            }
            return list;
        }

        public String getDisplayName() {
            return Messages.ExternalResource_DisplayName();
        }
    }
}

