/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli;

import com.sonyericsson.hudson.plugins.metadata.cli.CliResponse;
import com.sonyericsson.hudson.plugins.metadata.cli.CliUtils;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli.ErCliUtils;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AvailabilityFilter;
import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.RootAction;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class ExternalResourceHttpCommands
implements RootAction {
    private static final Logger logger = Logger.getLogger(ExternalResourceHttpCommands.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "external-resource-httpcli";
    }

    public void doEnable(@QueryParameter(value="node", required=true) String node, @QueryParameter(value="id", required=true) String id, StaplerResponse response) throws IOException {
        this.doEnableDisable(node, id, true, response);
    }

    public void doDisable(@QueryParameter(value="node", required=true) String node, @QueryParameter(value="id", required=true) String id, StaplerResponse response) throws IOException {
        this.doEnableDisable(node, id, false, response);
    }

    private void doEnableDisable(String node, String id, final boolean enable, StaplerResponse response) throws IOException {
        Something something = new Something(){

            @Override
            public void doIt(ExternalResource resource, StaplerResponse response) throws IOException {
                try {
                    resource.doEnable(enable);
                    CliResponse.sendOk((StaplerResponse)response);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Failed to save the changes to disk, but the resource state has changed.", (StaplerResponse)response);
                }
            }
        };
        this.doSomething(node, id, something, response);
    }

    public void doExpireReservation(@QueryParameter(value="node", required=true) String node, @QueryParameter(value="id", required=true) String id, StaplerResponse response) throws IOException {
        Something something = new Something(){

            @Override
            public void doIt(ExternalResource resource, StaplerResponse response) throws IOException {
                try {
                    resource.doExpireReservation();
                    CliResponse.sendOk((StaplerResponse)response);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Failed to save the changes to disk, but the resource state has changed.", (StaplerResponse)response);
                }
            }
        };
        this.doSomething(node, id, something, response);
    }

    public void doLockResource(final @QueryParameter(value="node", required=true) String node, final @QueryParameter(value="id", required=true) String id, final @QueryParameter(value="lockedBy", required=true) String lockedBy, final @QueryParameter(value="clientInfo", required=true) String clientInfo, StaplerResponse response) throws IOException {
        Something something = new Something(){

            @Override
            public void doIt(ExternalResource resource, StaplerResponse response) throws IOException {
                try {
                    if (ErCliUtils.isRequestCircular(clientInfo)) {
                        logger.log(Level.FINE, "Request was circular for: {0}", clientInfo);
                        CliResponse.sendIgnored((StaplerResponse)response);
                        return;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Locking resource: {0} on node: {1} with clientInfo: {2}", new Object[]{id, node, clientInfo});
                    }
                    StashInfo lockedInfo = new StashInfo(StashInfo.StashType.EXTERNAL, lockedBy, null, null);
                    resource.doLock(lockedInfo);
                    CliResponse.sendOk((StaplerResponse)response);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Failed to save the changes to disk, but the resource state has changed.", (StaplerResponse)response);
                }
            }
        };
        this.doSomething(node, id, something, response);
    }

    public void doReserveResource(final @QueryParameter(value="node", required=true) String node, final @QueryParameter(value="id", required=true) String id, final @QueryParameter(value="reservedBy", required=true) String reservedBy, final @QueryParameter(value="clientInfo", required=true) String clientInfo, StaplerResponse response) throws IOException {
        Something something = new Something(){

            @Override
            public void doIt(ExternalResource resource, StaplerResponse response) throws IOException {
                try {
                    if (ErCliUtils.isRequestCircular(clientInfo)) {
                        logger.log(Level.FINE, "Request was circular for: {0} ", clientInfo);
                        CliResponse.sendIgnored((StaplerResponse)response);
                        return;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Reserving resource: {0} on node: {1} with clientInfo: {2}", new Object[]{id, node, clientInfo});
                    }
                    StashInfo reservedInfo = new StashInfo(StashInfo.StashType.EXTERNAL, reservedBy, null, null);
                    resource.doReserve(reservedInfo);
                    CliResponse.sendOk((StaplerResponse)response);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Failed to save the changes to disk, but the resource state has changed.", (StaplerResponse)response);
                }
            }
        };
        this.doSomething(node, id, something, response);
    }

    public void doReleaseResource(final @QueryParameter(value="node", required=true) String node, final @QueryParameter(value="id", required=true) String id, final @QueryParameter(value="clientInfo", required=true) String clientInfo, StaplerResponse response) throws IOException {
        Something something = new Something(){

            @Override
            public void doIt(ExternalResource resource, StaplerResponse response) throws IOException {
                try {
                    if (ErCliUtils.isRequestCircular(clientInfo)) {
                        logger.log(Level.FINE, "Request was circular for: {0}", clientInfo);
                        CliResponse.sendIgnored((StaplerResponse)response);
                        return;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Releasing resource: {0} on node: {1} with clientInfo: {2}", new Object[]{id, node, clientInfo});
                    }
                    resource.doRelease();
                    CliResponse.sendOk((StaplerResponse)response);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Failed to save the changes to disk, but the resource state has changed.", (StaplerResponse)response);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not release resource! ", e);
                    CliResponse.sendResponse((CliResponse.Type)CliResponse.Type.warning, (int)0, (String)"Warning", (String)"Could not release resource.", (StaplerResponse)response);
                }
            }
        };
        this.doSomething(node, id, something, response);
    }

    private void doSomething(String node, String id, Something something, StaplerResponse response) throws IOException {
        Node theNode = Hudson.getInstance().getNode(node);
        if (theNode != null) {
            ExternalResource resource = AvailabilityFilter.getInstance().getExternalResourceById(theNode, id);
            if (resource != null) {
                something.doIt(resource, response);
            } else {
                CliResponse.sendError((CliUtils.Status)CliUtils.Status.ERR_NO_METADATA, (String)("No resource with id " + id + " exists on this node."), (StaplerResponse)response);
            }
        } else {
            CliResponse.sendError((CliUtils.Status)CliUtils.Status.ERR_NO_ITEM, (String)("No node with name " + node + " exists on this Jenkins server."), (StaplerResponse)response);
        }
    }

    private static interface Something {
        public void doIt(ExternalResource var1, StaplerResponse var2) throws IOException;
    }
}

