/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AvailabilityFilter;
import hudson.model.Hudson;
import hudson.model.Node;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.kohsuke.args4j.CmdLineException;

public final class ErCliUtils {
    public static ExternalResource findExternalResource(String nodeName, String id) throws CmdLineException {
        Node node = Hudson.getInstance().getNode(nodeName);
        if (node != null) {
            ExternalResource resource = AvailabilityFilter.getInstance().getExternalResourceById(node, id);
            if (resource != null) {
                return resource;
            }
            throw new CmdLineException(null, "No resource with id " + id + " exists on this node.");
        }
        throw new CmdLineException(null, "No node with name " + nodeName + " exists on this Jenkins server.");
    }

    public static boolean isRequestCircular(String clientInfo) {
        JSON json = JSONSerializer.toJSON((Object)clientInfo);
        JSONObject obj = null;
        if (json instanceof JSONObject) {
            obj = (JSONObject)json;
        }
        if (obj == null) {
            return false;
        }
        String clientId = "";
        try {
            clientId = obj.getString("id");
        }
        catch (JSONException e) {
            return false;
        }
        String rootUrl = Hudson.getInstance().getRootUrl();
        return clientId.equals(rootUrl);
    }

    private ErCliUtils() {
    }
}

