/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.cli.ErCliUtils;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.Option;

@Extension
public class EnableExternalResourceCommand
extends CLICommand {
    private static final Logger logger = Logger.getLogger(EnableExternalResourceCommand.class.getName());
    @Option(required=true, name="-node", usage="The name of the node")
    public String nodeName;
    @Option(required=true, name="-id", usage="The id of the external resource")
    public String id;

    public String getShortDescription() {
        return Messages.EnableExternalResourceCliCommand_Description();
    }

    protected int run() throws Exception {
        ExternalResource er = ErCliUtils.findExternalResource(this.nodeName, this.id);
        try {
            er.doEnable(true);
            this.stdout.println("OK");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Probably failed to save the node config to disk! ", e);
            this.stderr.println("Warning: The resource is enabled, but the changes failed to be saved to disk.");
        }
        return 0;
    }
}

