/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import com.sonyericsson.hudson.plugins.metadata.model.MetadataBuildAction;
import com.sonyericsson.hudson.plugins.metadata.model.values.AbstractMetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.MetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeNodeMetadataValue;
import com.sonyericsson.hudson.plugins.metadata.model.values.TreeStructureUtil;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Constants;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ReservedExternalResourceAction;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashInfo;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.selection.AbstractResourceSelection;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AdminNotifier;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Node;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SelectionCriteria
extends JobProperty<AbstractProject<?, ?>> {
    private static final Logger logger = Logger.getLogger(SelectionCriteria.class.getName());
    private boolean selectionEnabled;
    private List<AbstractResourceSelection> resourceSelectionList;

    @DataBoundConstructor
    public SelectionCriteria(boolean selectionEnabled, List<AbstractResourceSelection> resourceSelectionList) {
        this.selectionEnabled = selectionEnabled;
        this.resourceSelectionList = resourceSelectionList;
    }

    public SelectionCriteria(List<AbstractResourceSelection> resourceSelectionList) {
        this.resourceSelectionList = resourceSelectionList;
    }

    public synchronized List<AbstractResourceSelection> getResourceSelectionList() {
        if (this.resourceSelectionList == null) {
            this.resourceSelectionList = new LinkedList<AbstractResourceSelection>();
        }
        return this.resourceSelectionList;
    }

    public boolean getSelectionEnabled() {
        return this.selectionEnabled;
    }

    public List<ExternalResource> getMatchingResources(List<ExternalResource> availableResourceList) {
        LinkedList<ExternalResource> matchingResourceList = new LinkedList<ExternalResource>();
        boolean foundFlag = true;
        for (ExternalResource er : availableResourceList) {
            foundFlag = true;
            for (AbstractResourceSelection resourceSelection : this.resourceSelectionList) {
                if (resourceSelection.equalToExternalResourceValue(er)) continue;
                foundFlag = false;
                break;
            }
            if (!foundFlag) continue;
            matchingResourceList.add(er);
        }
        return matchingResourceList;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        ExternalResource locked;
        StashResult lockResult;
        if (!this.getSelectionEnabled()) {
            logger.log(Level.FINE, "Selection not enabled, continuing");
            return true;
        }
        String buildName = build.getFullDisplayName();
        Node node = build.getBuiltOn();
        ReservedExternalResourceAction action = (ReservedExternalResourceAction)build.getAction(ReservedExternalResourceAction.class);
        if (action == null) {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.RESERVE, node, null, "No phone chosen even though we have selection criteria, aborting build: " + buildName);
            logger.log(Level.SEVERE, "No phone chosen even though we have selection criteria, aborting build: [{0}].", buildName);
            listener.getLogger().println("No phone chosen even though we have selection criteria, aborting build.");
            return false;
        }
        ExternalResource reserved = action.pop();
        StashInfo reservedInfo = reserved.getReserved();
        ExternalResourceManager resourceManager = PluginImpl.getInstance().getManager();
        if (reservedInfo == null) {
            StashResult result = resourceManager.reserve(node, reserved, PluginImpl.getInstance().getReserveTime(), build.getDisplayName());
            if (result == null || !result.isOk()) {
                AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.RESERVE, node, reserved, "The external resource has been taken by someone else, aborting build: " + buildName);
                logger.log(Level.SEVERE, "External resource: [{0}] has been taken by someone else, aborting build", reserved.getId());
                listener.getLogger().println("External resource: " + reserved.getId() + " has been taken by someone else, aborting build");
                return false;
            }
            reservedInfo = new StashInfo(result, build.getUrl());
        }
        if ((lockResult = resourceManager.lock(node, reserved, reservedInfo.getKey(), build.getUrl())) == null || !lockResult.isOk()) {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.LOCK, node, reserved, "Could not lock resource, aborting the build: " + buildName);
            logger.log(Level.SEVERE, "Could not lock resource: [{0}], aborting the build: [{1}].", new String[]{reserved.getId(), buildName});
            listener.getLogger().println("Could not lock resource: " + reserved.getId() + ", aborting the build.");
            return false;
        }
        try {
            locked = reserved.clone();
        }
        catch (CloneNotSupportedException e) {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.ERROR, AdminNotifier.OperationType.LOCK, node, reserved, "Could not clone the External resource, aborting the build: " + buildName);
            logger.log(Level.SEVERE, "Could not clone the External resource: [{0}], aborting the build: [{1}].", new String[]{reserved.getId(), buildName});
            listener.getLogger().println("Could not clone the External resource: " + reserved.getId() + ", aborting the build.");
            return false;
        }
        MetadataBuildAction metadataBuildAction = (MetadataBuildAction)build.getAction(MetadataBuildAction.class);
        if (metadataBuildAction == null) {
            metadataBuildAction = new MetadataBuildAction(build);
            build.addAction((Action)metadataBuildAction);
        }
        locked.setName("locked");
        TreeNodeMetadataValue lockedTree = TreeStructureUtil.createPath((AbstractMetadataValue)locked, (String[])Constants.getBuildLockedResourceParentPath());
        metadataBuildAction.addChild((MetadataValue)lockedTree);
        locked.setExposeToEnvironment(true);
        return true;
    }

    @Extension
    public static class SelectionCriteriaDescriptor
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.SelectionCriteria_DisplayName();
        }

        public List<AbstractResourceSelection.AbstractResourceSelectionDescriptor> getResourceSelectionDescriptors() {
            return Hudson.getInstance().getExtensionList(AbstractResourceSelection.AbstractResourceSelectionDescriptor.class);
        }
    }
}

