/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.Messages;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.NoopExternalResourceManager;
import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Items;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class PluginImpl
extends Plugin {
    public static final Logger logger = Logger.getLogger(PluginImpl.class.getName());
    public static final PermissionGroup GROUP = new PermissionGroup(PluginImpl.class, Messages._ExternalResource_DisplayName());
    public static final Permission ADMINISTER_EXTERNAL_RESOURCE = new Permission(GROUP, "Administer", Messages._ExternalResource_Administer(), Computer.CONFIGURE);
    public static final Permission ENABLE_DISABLE_EXTERNAL_RESOURCE = new Permission(GROUP, "EnableDisable", Messages._ExternalResource_EnableDisable(), ADMINISTER_EXTERNAL_RESOURCE);
    public static final Permission LOCK_RELEASE_EXTERNAL_RESOURCE = new Permission(GROUP, "LockRelease", Messages._ExternalResource_LockRelease(), ADMINISTER_EXTERNAL_RESOURCE);
    protected static final String FORM_NAME_RELEASE_KEY = "releaseKey";
    protected static final String FORM_NAME_MANAGER = "manager";
    protected static final String FORM_NAME_RESERVE_TIME = "reserveTime";
    protected static final String FORM_NAME_ADMIN_FILE = "adminNotifierFile";
    private String releaseKey;
    private transient ExternalResourceManager manager;
    private String managerClass;
    private int reserveTime = 3;
    private String adminNotifierFile;

    public void start() throws Exception {
        this.registerXStreamAlias();
        this.load();
    }

    private void registerXStreamAlias() {
        Class[] types = new Class[]{ExternalResource.class};
        Hudson.XSTREAM.processAnnotations(types);
        Items.XSTREAM.processAnnotations(types);
        Run.XSTREAM.processAnnotations(types);
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.releaseKey = formData.getString(FORM_NAME_RELEASE_KEY);
        String managerName = formData.getString(FORM_NAME_MANAGER);
        ExternalResourceManager dynamic = (ExternalResourceManager)this.getAvailableExternalResourceManagers().getDynamic(managerName);
        if (dynamic == null) {
            throw new Descriptor.FormException("Unknown manager: " + managerName, FORM_NAME_MANAGER);
        }
        this.manager = dynamic;
        this.managerClass = dynamic.getClass().getName();
        this.reserveTime = formData.getInt(FORM_NAME_RESERVE_TIME);
        this.adminNotifierFile = formData.getString(FORM_NAME_ADMIN_FILE);
        logger.fine("Saving config.");
        this.save();
    }

    public ExtensionList<ExternalResourceManager> getAvailableExternalResourceManagers() {
        return Hudson.getInstance().getExtensionList(ExternalResourceManager.class);
    }

    public static PluginImpl getInstance() {
        PluginImpl instance = (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
        if (instance == null) {
            throw new IllegalStateException("Plugin is not loaded!");
        }
        return instance;
    }

    public String getReleaseKey() {
        return this.releaseKey;
    }

    public static ExternalResourceManager getNoopResourceManager() {
        return (ExternalResourceManager)Hudson.getInstance().getExtensionList(ExternalResourceManager.class).get(NoopExternalResourceManager.class);
    }

    public synchronized ExternalResourceManager getManager() {
        if (this.manager == null) {
            if (this.managerClass != null && !this.managerClass.isEmpty()) {
                ExternalResourceManager dynamic = (ExternalResourceManager)this.getAvailableExternalResourceManagers().getDynamic(this.managerClass);
                if (dynamic != null) {
                    this.manager = dynamic;
                } else {
                    logger.severe("The configured external resource manager could not be found! " + this.managerClass + " Using the default No-Op-manager.");
                    this.manager = PluginImpl.getNoopResourceManager();
                }
            } else {
                logger.severe("No configured external resource manager could be found! Using the default No-Op-manager.");
                this.manager = PluginImpl.getNoopResourceManager();
            }
        }
        return this.manager;
    }

    public int getReserveTime() {
        return this.reserveTime;
    }

    public int getDefaultReserveTime() {
        return 3;
    }

    public String getAdminNotifierFile() {
        return this.adminNotifierFile;
    }
}

