/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.externalresource.dispatcher;

import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.PluginImpl;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.SelectionCriteria;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ExternalResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.ReservedExternalResourceAction;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.StashResult;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.veto.BecauseAlreadyReserved;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.veto.BecauseNoAvailableResources;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.veto.BecauseNoMatchingResource;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.data.veto.BecauseNothingReserved;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AdminNotifier;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.AvailabilityFilter;
import com.sonyericsson.jenkins.plugins.externalresource.dispatcher.utils.resourcemanagers.ExternalResourceManager;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension(ordinal=5.0)
public class ExternalResourceQueueTaskDispatcher
extends QueueTaskDispatcher {
    private static final Logger logger = Logger.getLogger(ExternalResourceQueueTaskDispatcher.class.getName());

    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        logger.entering("ExternalResourceQueueTaskDispatcher", "canTake", new Object[]{node, item});
        ReservedExternalResourceAction storage = this.getReservedExternalResourceAction(item);
        if (!storage.isEmpty()) {
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "BecauseAlreadyReserved");
            return new BecauseAlreadyReserved();
        }
        SelectionCriteria selectionCriteria = this.getSelectionCriteria(item.task);
        if (selectionCriteria == null || !selectionCriteria.getSelectionEnabled() || selectionCriteria.getResourceSelectionList() == null || selectionCriteria.getResourceSelectionList().isEmpty()) {
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "OK - not buildable or no selection");
            return null;
        }
        AvailabilityFilter availabilityFilter = AvailabilityFilter.getInstance();
        List<ExternalResource> resources = availabilityFilter.getExternalResourcesList(node);
        if (resources == null || resources.isEmpty()) {
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "BecauseNoAvailableResources-1");
            return new BecauseNoAvailableResources(node);
        }
        if ((resources = availabilityFilter.filterEnabledAndAvailable(resources)) == null || resources.isEmpty()) {
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "BecauseNoAvailableResources-2");
            return new BecauseNoAvailableResources(node);
        }
        if ((resources = selectionCriteria.getMatchingResources(resources)) == null || resources.isEmpty()) {
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "BecauseNoMatchingResource");
            return new BecauseNoMatchingResource(node);
        }
        ExternalResource reservedResource = null;
        ExternalResourceManager manager = PluginImpl.getInstance().getManager();
        for (ExternalResource resource : resources) {
            StashResult result = manager.reserve(node, resource, PluginImpl.getInstance().getReserveTime(), item.task.getUrl());
            logger.log(Level.FINEST, "Reserve result for [{0}]: Status {1} code {2} message {3}", new Object[]{resource.getFullName(), result.getStatus().name(), result.getErrorCode(), result.getMessage()});
            if (result != null && result.isOk()) {
                reservedResource = resource;
                logger.finest("reservation ok");
                break;
            }
            logger.finest("Not reserved");
        }
        if (reservedResource == null) {
            AdminNotifier.getInstance().notify(AdminNotifier.MessageType.WARNING, AdminNotifier.OperationType.RESERVE, node, reservedResource, "Found one or more matching external resources but could not reserve any of them.");
            logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "BecauseNothingReserved");
            return new BecauseNothingReserved(node);
        }
        storage.push(reservedResource);
        logger.exiting("ExternalResourceQueueTaskDispatcher", "canTake", "OK");
        return null;
    }

    private ReservedExternalResourceAction getReservedExternalResourceAction(Queue.BuildableItem item) {
        List actions = item.getActions(ReservedExternalResourceAction.class);
        if (actions != null && actions.size() > 0) {
            return (ReservedExternalResourceAction)actions.get(0);
        }
        ReservedExternalResourceAction storage = new ReservedExternalResourceAction();
        item.addAction((Action)storage);
        return storage;
    }

    private String getUrl(Queue.Task task) {
        AbstractProject p = this.getProject(task);
        if (p != null) {
            return p.getAbsoluteUrl();
        }
        return "";
    }

    private AbstractProject getProject(Queue.Task task) {
        if (task instanceof AbstractProject) {
            AbstractProject p = (AbstractProject)task;
            if (task instanceof MatrixConfiguration) {
                p = ((MatrixConfiguration)task).getParent();
            }
            return p;
        }
        return null;
    }

    private SelectionCriteria getSelectionCriteria(Queue.Task task) {
        AbstractProject p = this.getProject(task);
        if (p != null) {
            return (SelectionCriteria)p.getProperty(SelectionCriteria.class);
        }
        return null;
    }
}

